/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.util;

import java.util.NoSuchElementException;

public class CircularBuffer<T> {
    final Object[] buffer;
    int head;
    int tail;

    public CircularBuffer(int size) {
        this.buffer = new Object[size];
    }

    public void add(T value) {
        this.buffer[this.tail++ % this.buffer.length] = value;
        if (this.size() > this.buffer.length) {
            ++this.head;
        }
    }

    public T get(int index) {
        if (index < this.head) {
            throw new IllegalArgumentException("read before head");
        }
        if (index >= this.tail) {
            throw new IllegalArgumentException("read after tail");
        }
        return (T)this.buffer[index % this.buffer.length];
    }

    public T take() {
        if (this.tail == this.head) {
            throw new NoSuchElementException();
        }
        int idx = this.head++ % this.buffer.length;
        Object value = this.buffer[idx];
        this.buffer[idx] = null;
        return (T)value;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public int size() {
        return this.tail - this.head;
    }

    public int head() {
        return this.head;
    }

    public int tail() {
        return this.tail;
    }
}

