/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable;

import io.reactivex.common.Disposable;
import io.reactivex.common.annotations.NonNull;
import io.reactivex.common.functions.Consumer;
import io.reactivex.common.internal.functions.Functions;
import io.reactivex.common.internal.utils.ConnectConsumer;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.RxJavaFlowablePlugins;
import io.reactivex.flowable.internal.operators.FlowableAutoConnect;
import io.reactivex.flowable.internal.operators.FlowableRefCount;

public abstract class ConnectableFlowable<T>
extends Flowable<T> {
    public abstract void connect(@NonNull Consumer<? super Disposable> var1);

    public final Disposable connect() {
        ConnectConsumer cc = new ConnectConsumer();
        this.connect((Consumer<Disposable>)cc);
        return cc.disposable;
    }

    @NonNull
    public Flowable<T> refCount() {
        return RxJavaFlowablePlugins.onAssembly(new FlowableRefCount(this));
    }

    @NonNull
    public Flowable<T> autoConnect() {
        return this.autoConnect(1);
    }

    @NonNull
    public Flowable<T> autoConnect(int numberOfSubscribers) {
        return this.autoConnect(numberOfSubscribers, (Consumer<Disposable>)Functions.emptyConsumer());
    }

    @NonNull
    public Flowable<T> autoConnect(int numberOfSubscribers, @NonNull Consumer<? super Disposable> connection) {
        if (numberOfSubscribers <= 0) {
            this.connect(connection);
            return RxJavaFlowablePlugins.onAssembly(this);
        }
        return RxJavaFlowablePlugins.onAssembly(new FlowableAutoConnect(this, numberOfSubscribers, connection));
    }
}

