/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable;

import io.reactivex.common.Scheduler;
import io.reactivex.common.annotations.Experimental;
import io.reactivex.common.annotations.NonNull;
import io.reactivex.common.annotations.Nullable;
import io.reactivex.common.functions.BiFunction;
import io.reactivex.common.functions.Function;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.common.internal.schedulers.ComputationScheduler;
import io.reactivex.common.internal.schedulers.IoScheduler;
import io.reactivex.common.internal.schedulers.NewThreadScheduler;
import io.reactivex.common.internal.schedulers.SingleScheduler;
import io.reactivex.common.internal.utils.ExceptionHelper;
import io.reactivex.flowable.ConnectableFlowable;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.ParallelFlowable;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import org.reactivestreams.Subscriber;

public final class RxJavaFlowablePlugins {
    @Nullable
    static volatile Function<? super Flowable, ? extends Flowable> onFlowableAssembly;
    @Nullable
    static volatile Function<? super ConnectableFlowable, ? extends ConnectableFlowable> onConnectableFlowableAssembly;
    @Nullable
    static volatile Function<? super ParallelFlowable, ? extends ParallelFlowable> onParallelAssembly;
    @Nullable
    static volatile BiFunction<? super Flowable, ? super Subscriber, ? extends Subscriber> onFlowableSubscribe;
    static volatile boolean lockdown;

    public static void lockdown() {
        lockdown = true;
    }

    public static boolean isLockdown() {
        return lockdown;
    }

    public static void reset() {
        RxJavaFlowablePlugins.setOnFlowableAssembly(null);
        RxJavaFlowablePlugins.setOnFlowableSubscribe(null);
        RxJavaFlowablePlugins.setOnConnectableFlowableAssembly(null);
        RxJavaFlowablePlugins.setOnParallelAssembly(null);
    }

    static void unlock() {
        lockdown = false;
    }

    @Nullable
    public static Function<? super Flowable, ? extends Flowable> getOnFlowableAssembly() {
        return onFlowableAssembly;
    }

    @Nullable
    public static Function<? super ConnectableFlowable, ? extends ConnectableFlowable> getOnConnectableFlowableAssembly() {
        return onConnectableFlowableAssembly;
    }

    @Nullable
    public static BiFunction<? super Flowable, ? super Subscriber, ? extends Subscriber> getOnFlowableSubscribe() {
        return onFlowableSubscribe;
    }

    public static void setOnFlowableAssembly(@Nullable Function<? super Flowable, ? extends Flowable> onFlowableAssembly) {
        if (lockdown) {
            throw new IllegalStateException("Plugins can't be changed anymore");
        }
        RxJavaFlowablePlugins.onFlowableAssembly = onFlowableAssembly;
    }

    public static void setOnConnectableFlowableAssembly(@Nullable Function<? super ConnectableFlowable, ? extends ConnectableFlowable> onConnectableFlowableAssembly) {
        if (lockdown) {
            throw new IllegalStateException("Plugins can't be changed anymore");
        }
        RxJavaFlowablePlugins.onConnectableFlowableAssembly = onConnectableFlowableAssembly;
    }

    public static void setOnFlowableSubscribe(@Nullable BiFunction<? super Flowable, ? super Subscriber, ? extends Subscriber> onFlowableSubscribe) {
        if (lockdown) {
            throw new IllegalStateException("Plugins can't be changed anymore");
        }
        RxJavaFlowablePlugins.onFlowableSubscribe = onFlowableSubscribe;
    }

    @NonNull
    public static <T> Subscriber<? super T> onSubscribe(@NonNull Flowable<T> source, @NonNull Subscriber<? super T> subscriber) {
        BiFunction<? super Flowable, ? super Subscriber, ? extends Subscriber> f = onFlowableSubscribe;
        if (f != null) {
            return RxJavaFlowablePlugins.apply(f, source, subscriber);
        }
        return subscriber;
    }

    @NonNull
    public static <T> Flowable<T> onAssembly(@NonNull Flowable<T> source) {
        Function<? super Flowable, ? extends Flowable> f = onFlowableAssembly;
        if (f != null) {
            return RxJavaFlowablePlugins.apply(f, source);
        }
        return source;
    }

    @NonNull
    public static <T> ConnectableFlowable<T> onAssembly(@NonNull ConnectableFlowable<T> source) {
        Function<? super ConnectableFlowable, ? extends ConnectableFlowable> f = onConnectableFlowableAssembly;
        if (f != null) {
            return RxJavaFlowablePlugins.apply(f, source);
        }
        return source;
    }

    @Experimental
    public static void setOnParallelAssembly(@Nullable Function<? super ParallelFlowable, ? extends ParallelFlowable> handler) {
        if (lockdown) {
            throw new IllegalStateException("Plugins can't be changed anymore");
        }
        onParallelAssembly = handler;
    }

    @Experimental
    @Nullable
    public static Function<? super ParallelFlowable, ? extends ParallelFlowable> getOnParallelAssembly() {
        return onParallelAssembly;
    }

    @Experimental
    @NonNull
    public static <T> ParallelFlowable<T> onAssembly(@NonNull ParallelFlowable<T> source) {
        Function<? super ParallelFlowable, ? extends ParallelFlowable> f = onParallelAssembly;
        if (f != null) {
            return RxJavaFlowablePlugins.apply(f, source);
        }
        return source;
    }

    @Experimental
    @NonNull
    public static Scheduler createComputationScheduler(@NonNull ThreadFactory threadFactory) {
        return new ComputationScheduler((ThreadFactory)ObjectHelper.requireNonNull((Object)threadFactory, (String)"threadFactory is null"));
    }

    @Experimental
    @NonNull
    public static Scheduler createIoScheduler(@NonNull ThreadFactory threadFactory) {
        return new IoScheduler((ThreadFactory)ObjectHelper.requireNonNull((Object)threadFactory, (String)"threadFactory is null"));
    }

    @Experimental
    @NonNull
    public static Scheduler createNewThreadScheduler(@NonNull ThreadFactory threadFactory) {
        return new NewThreadScheduler((ThreadFactory)ObjectHelper.requireNonNull((Object)threadFactory, (String)"threadFactory is null"));
    }

    @Experimental
    @NonNull
    public static Scheduler createSingleScheduler(@NonNull ThreadFactory threadFactory) {
        return new SingleScheduler((ThreadFactory)ObjectHelper.requireNonNull((Object)threadFactory, (String)"threadFactory is null"));
    }

    @NonNull
    static <T, R> R apply(@NonNull Function<T, R> f, @NonNull T t) {
        try {
            return (R)f.apply(t);
        }
        catch (Throwable ex) {
            throw ExceptionHelper.wrapOrThrow((Throwable)ex);
        }
    }

    @NonNull
    static <T, U, R> R apply(@NonNull BiFunction<T, U, R> f, @NonNull T t, @NonNull U u) {
        try {
            return (R)f.apply(t, u);
        }
        catch (Throwable ex) {
            throw ExceptionHelper.wrapOrThrow((Throwable)ex);
        }
    }

    @NonNull
    static Scheduler callRequireNonNull(@NonNull Callable<Scheduler> s) {
        try {
            return (Scheduler)ObjectHelper.requireNonNull((Object)s.call(), (String)"Scheduler Callable result can't be null");
        }
        catch (Throwable ex) {
            throw ExceptionHelper.wrapOrThrow((Throwable)ex);
        }
    }

    @NonNull
    static Scheduler applyRequireNonNull(@NonNull Function<? super Callable<Scheduler>, ? extends Scheduler> f, Callable<Scheduler> s) {
        return (Scheduler)ObjectHelper.requireNonNull((Object)RxJavaFlowablePlugins.apply(f, s), (String)"Scheduler Callable result can't be null");
    }

    private RxJavaFlowablePlugins() {
        throw new IllegalStateException("No instances!");
    }
}

