/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.Scheduler;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import io.reactivex.flowable.subscribers.SerializedSubscriber;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableDelay<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean delayError;

    public FlowableDelay(Flowable<T> source, long delay, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        super(source);
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> t) {
        Object s = this.delayError ? t : new SerializedSubscriber<T>(t);
        Scheduler.Worker w = this.scheduler.createWorker();
        this.source.subscribe(new DelaySubscriber<T>(s, this.delay, this.unit, w, this.delayError));
    }

    static final class DelaySubscriber<T>
    implements RelaxedSubscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        final long delay;
        final TimeUnit unit;
        final Scheduler.Worker w;
        final boolean delayError;
        Subscription s;

        DelaySubscriber(Subscriber<? super T> actual, long delay, TimeUnit unit, Scheduler.Worker w, boolean delayError) {
            this.actual = actual;
            this.delay = delay;
            this.unit = unit;
            this.w = w;
            this.delayError = delayError;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.w.schedule((Runnable)new OnNext(t), this.delay, this.unit);
        }

        public void onError(Throwable t) {
            this.w.schedule((Runnable)new OnError(t), this.delayError ? this.delay : 0L, this.unit);
        }

        public void onComplete() {
            this.w.schedule((Runnable)new OnComplete(), this.delay, this.unit);
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
            this.w.dispose();
        }

        final class OnComplete
        implements Runnable {
            OnComplete() {
            }

            @Override
            public void run() {
                try {
                    DelaySubscriber.this.actual.onComplete();
                }
                finally {
                    DelaySubscriber.this.w.dispose();
                }
            }
        }

        final class OnError
        implements Runnable {
            private final Throwable t;

            OnError(Throwable t) {
                this.t = t;
            }

            @Override
            public void run() {
                try {
                    DelaySubscriber.this.actual.onError(this.t);
                }
                finally {
                    DelaySubscriber.this.w.dispose();
                }
            }
        }

        final class OnNext
        implements Runnable {
            private final T t;

            OnNext(T t) {
                this.t = t;
            }

            @Override
            public void run() {
                DelaySubscriber.this.actual.onNext(this.t);
            }
        }
    }
}

