/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.subscriptions.EmptySubscription;
import java.util.concurrent.Callable;
import org.reactivestreams.Subscriber;

public final class FlowableError<T>
extends Flowable<T> {
    final Callable<? extends Throwable> errorSupplier;

    public FlowableError(Callable<? extends Throwable> errorSupplier) {
        this.errorSupplier = errorSupplier;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        Throwable error;
        try {
            error = (Throwable)ObjectHelper.requireNonNull((Object)this.errorSupplier.call(), (String)"Callable returned null throwable. Null values are generally not allowed in 2.x operators and sources.");
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal((Throwable)t);
            error = t;
        }
        EmptySubscription.error(error, s);
    }
}

