/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.subscriptions.DeferredScalarSubscription;
import java.util.concurrent.Callable;
import org.reactivestreams.Subscriber;

public final class FlowableFromCallable<T>
extends Flowable<T>
implements Callable<T> {
    final Callable<? extends T> callable;

    public FlowableFromCallable(Callable<? extends T> callable) {
        this.callable = callable;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        Object t;
        DeferredScalarSubscription<Object> deferred = new DeferredScalarSubscription<Object>(s);
        s.onSubscribe(deferred);
        try {
            t = ObjectHelper.requireNonNull(this.callable.call(), (String)"The callable returned a null value");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            s.onError(ex);
            return;
        }
        deferred.complete(t);
    }

    @Override
    public T call() throws Exception {
        return (T)ObjectHelper.requireNonNull(this.callable.call(), (String)"The callable returned a null value");
    }
}

