/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import io.reactivex.common.Notification;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscribers.SinglePostCompleteSubscriber;
import org.reactivestreams.Subscriber;

public final class FlowableMaterialize<T>
extends AbstractFlowableWithUpstream<T, Notification<T>> {
    public FlowableMaterialize(Flowable<T> source) {
        super(source);
    }

    @Override
    protected void subscribeActual(Subscriber<? super Notification<T>> s) {
        this.source.subscribe(new MaterializeSubscriber(s));
    }

    static final class MaterializeSubscriber<T>
    extends SinglePostCompleteSubscriber<T, Notification<T>> {
        private static final long serialVersionUID = -3740826063558713822L;

        MaterializeSubscriber(Subscriber<? super Notification<T>> actual) {
            super(actual);
        }

        public void onNext(T t) {
            ++this.produced;
            this.actual.onNext((Object)Notification.createOnNext(t));
        }

        public void onError(Throwable t) {
            this.complete(Notification.createOnError((Throwable)t));
        }

        public void onComplete() {
            this.complete(Notification.createOnComplete());
        }

        @Override
        protected void onDrop(Notification<T> n) {
            if (n.isOnError()) {
                RxJavaCommonPlugins.onError((Throwable)n.getError());
            }
        }
    }
}

