/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.CompositeException;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.Function;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscriptions.SubscriptionArbiter;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableOnErrorNext<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier;
    final boolean allowFatal;

    public FlowableOnErrorNext(Flowable<T> source, Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier, boolean allowFatal) {
        super(source);
        this.nextSupplier = nextSupplier;
        this.allowFatal = allowFatal;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        OnErrorNextSubscriber<? super T> parent = new OnErrorNextSubscriber<T>(s, this.nextSupplier, this.allowFatal);
        s.onSubscribe((Subscription)parent.arbiter);
        this.source.subscribe(parent);
    }

    static final class OnErrorNextSubscriber<T>
    implements RelaxedSubscriber<T> {
        final Subscriber<? super T> actual;
        final Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier;
        final boolean allowFatal;
        final SubscriptionArbiter arbiter;
        boolean once;
        boolean done;

        OnErrorNextSubscriber(Subscriber<? super T> actual, Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier, boolean allowFatal) {
            this.actual = actual;
            this.nextSupplier = nextSupplier;
            this.allowFatal = allowFatal;
            this.arbiter = new SubscriptionArbiter();
        }

        public void onSubscribe(Subscription s) {
            this.arbiter.setSubscription(s);
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            this.actual.onNext(t);
            if (!this.once) {
                this.arbiter.produced(1L);
            }
        }

        public void onError(Throwable t) {
            Publisher p;
            if (this.once) {
                if (this.done) {
                    RxJavaCommonPlugins.onError((Throwable)t);
                    return;
                }
                this.actual.onError(t);
                return;
            }
            this.once = true;
            if (this.allowFatal && !(t instanceof Exception)) {
                this.actual.onError(t);
                return;
            }
            try {
                p = (Publisher)this.nextSupplier.apply((Object)t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.actual.onError((Throwable)new CompositeException(new Throwable[]{t, e}));
                return;
            }
            if (p == null) {
                NullPointerException npe = new NullPointerException("Publisher is null");
                npe.initCause(t);
                this.actual.onError((Throwable)npe);
                return;
            }
            p.subscribe((Subscriber)this);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.once = true;
            this.actual.onComplete();
        }
    }
}

