/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.exceptions.CompositeException;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.BiPredicate;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscriptions.SubscriptionArbiter;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableRetryBiPredicate<T>
extends AbstractFlowableWithUpstream<T, T> {
    final BiPredicate<? super Integer, ? super Throwable> predicate;

    public FlowableRetryBiPredicate(Flowable<T> source, BiPredicate<? super Integer, ? super Throwable> predicate) {
        super(source);
        this.predicate = predicate;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        SubscriptionArbiter sa = new SubscriptionArbiter();
        s.onSubscribe((Subscription)sa);
        RetryBiSubscriber<T> rs = new RetryBiSubscriber<T>(s, this.predicate, sa, this.source);
        rs.subscribeNext();
    }

    static final class RetryBiSubscriber<T>
    extends AtomicInteger
    implements RelaxedSubscriber<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final Subscriber<? super T> actual;
        final SubscriptionArbiter sa;
        final Publisher<? extends T> source;
        final BiPredicate<? super Integer, ? super Throwable> predicate;
        int retries;

        RetryBiSubscriber(Subscriber<? super T> actual, BiPredicate<? super Integer, ? super Throwable> predicate, SubscriptionArbiter sa, Publisher<? extends T> source) {
            this.actual = actual;
            this.sa = sa;
            this.source = source;
            this.predicate = predicate;
        }

        public void onSubscribe(Subscription s) {
            this.sa.setSubscription(s);
        }

        public void onNext(T t) {
            this.actual.onNext(t);
            this.sa.produced(1L);
        }

        public void onError(Throwable t) {
            boolean b;
            try {
                b = this.predicate.test((Object)(++this.retries), (Object)t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.actual.onError((Throwable)new CompositeException(new Throwable[]{t, e}));
                return;
            }
            if (!b) {
                this.actual.onError(t);
                return;
            }
            this.subscribeNext();
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        void subscribeNext() {
            block2: {
                if (this.getAndIncrement() != 0) break block2;
                int missed = 1;
                do {
                    if (this.sa.isCancelled()) {
                        return;
                    }
                    this.source.subscribe((Subscriber)this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

