/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.Scheduler;
import io.reactivex.common.exceptions.MissingBackpressureException;
import io.reactivex.common.internal.disposables.DisposableHelper;
import io.reactivex.common.internal.disposables.SequentialDisposable;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import io.reactivex.flowable.internal.utils.BackpressureHelper;
import io.reactivex.flowable.subscribers.SerializedSubscriber;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSampleTimed<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long period;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean emitLast;

    public FlowableSampleTimed(Flowable<T> source, long period, TimeUnit unit, Scheduler scheduler, boolean emitLast) {
        super(source);
        this.period = period;
        this.unit = unit;
        this.scheduler = scheduler;
        this.emitLast = emitLast;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        SerializedSubscriber<? super T> serial = new SerializedSubscriber<T>(s);
        if (this.emitLast) {
            this.source.subscribe(new SampleTimedEmitLast<T>(serial, this.period, this.unit, this.scheduler));
        } else {
            this.source.subscribe(new SampleTimedNoLast<T>(serial, this.period, this.unit, this.scheduler));
        }
    }

    static final class SampleTimedEmitLast<T>
    extends SampleTimedSubscriber<T> {
        private static final long serialVersionUID = -7139995637533111443L;
        final AtomicInteger wip = new AtomicInteger(1);

        SampleTimedEmitLast(Subscriber<? super T> actual, long period, TimeUnit unit, Scheduler scheduler) {
            super(actual, period, unit, scheduler);
        }

        @Override
        void complete() {
            this.emit();
            if (this.wip.decrementAndGet() == 0) {
                this.actual.onComplete();
            }
        }

        @Override
        public void run() {
            if (this.wip.incrementAndGet() == 2) {
                this.emit();
                if (this.wip.decrementAndGet() == 0) {
                    this.actual.onComplete();
                }
            }
        }
    }

    static final class SampleTimedNoLast<T>
    extends SampleTimedSubscriber<T> {
        private static final long serialVersionUID = -7139995637533111443L;

        SampleTimedNoLast(Subscriber<? super T> actual, long period, TimeUnit unit, Scheduler scheduler) {
            super(actual, period, unit, scheduler);
        }

        @Override
        void complete() {
            this.actual.onComplete();
        }

        @Override
        public void run() {
            this.emit();
        }
    }

    static abstract class SampleTimedSubscriber<T>
    extends AtomicReference<T>
    implements RelaxedSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = -3517602651313910099L;
        final Subscriber<? super T> actual;
        final long period;
        final TimeUnit unit;
        final Scheduler scheduler;
        final AtomicLong requested = new AtomicLong();
        final SequentialDisposable timer = new SequentialDisposable();
        Subscription s;

        SampleTimedSubscriber(Subscriber<? super T> actual, long period, TimeUnit unit, Scheduler scheduler) {
            this.actual = actual;
            this.period = period;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                this.timer.replace(this.scheduler.schedulePeriodicallyDirect((Runnable)this, this.period, this.period, this.unit));
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.lazySet(t);
        }

        public void onError(Throwable t) {
            this.cancelTimer();
            this.actual.onError(t);
        }

        public void onComplete() {
            this.cancelTimer();
            this.complete();
        }

        void cancelTimer() {
            DisposableHelper.dispose((AtomicReference)this.timer);
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
            }
        }

        public void cancel() {
            this.cancelTimer();
            this.s.cancel();
        }

        void emit() {
            Object value = this.getAndSet(null);
            if (value != null) {
                long r = this.requested.get();
                if (r != 0L) {
                    this.actual.onNext(value);
                    BackpressureHelper.produced(this.requested, 1L);
                } else {
                    this.cancel();
                    this.actual.onError((Throwable)new MissingBackpressureException("Couldn't emit value due to lack of requests!"));
                }
            }
        }

        abstract void complete();
    }
}

