/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.FusedQueue;
import hu.akarnokd.reactivestreams.extensions.FusedQueueSubscription;
import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.exceptions.MissingBackpressureException;
import io.reactivex.common.functions.BiPredicate;
import io.reactivex.common.internal.utils.AtomicThrowable;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.queues.SpscArrayQueue;
import io.reactivex.flowable.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSequenceEqual<T>
extends Flowable<Boolean> {
    final Publisher<? extends T> first;
    final Publisher<? extends T> second;
    final BiPredicate<? super T, ? super T> comparer;
    final int prefetch;

    public FlowableSequenceEqual(Publisher<? extends T> first, Publisher<? extends T> second, BiPredicate<? super T, ? super T> comparer, int prefetch) {
        this.first = first;
        this.second = second;
        this.comparer = comparer;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribeActual(Subscriber<? super Boolean> s) {
        EqualCoordinator<? extends T> parent = new EqualCoordinator<T>(s, this.prefetch, this.comparer);
        s.onSubscribe(parent);
        parent.subscribe(this.first, this.second);
    }

    public static final class EqualSubscriber<T>
    extends AtomicReference<Subscription>
    implements RelaxedSubscriber<T> {
        private static final long serialVersionUID = 4804128302091633067L;
        final EqualCoordinatorHelper parent;
        final int prefetch;
        final int limit;
        long produced;
        public volatile FusedQueue<T> queue;
        public volatile boolean done;
        int sourceMode;

        public EqualSubscriber(EqualCoordinatorHelper parent, int prefetch) {
            this.parent = parent;
            this.limit = prefetch - (prefetch >> 2);
            this.prefetch = prefetch;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this, s)) {
                if (s instanceof FusedQueueSubscription) {
                    FusedQueueSubscription qs = (FusedQueueSubscription)s;
                    int m = qs.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qs;
                        s.request((long)this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                s.request((long)this.prefetch);
            }
        }

        public void onNext(T t) {
            if (this.sourceMode == 0 && !this.queue.offer(t)) {
                this.onError((Throwable)new MissingBackpressureException());
                return;
            }
            this.parent.drain();
        }

        public void onError(Throwable t) {
            this.parent.innerError(t);
        }

        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        public void request() {
            if (this.sourceMode != 1) {
                long p = this.produced + 1L;
                if (p >= (long)this.limit) {
                    this.produced = 0L;
                    ((Subscription)this.get()).request(p);
                } else {
                    this.produced = p;
                }
            }
        }

        public void cancel() {
            SubscriptionHelper.cancel(this);
        }

        public void clear() {
            FusedQueue<T> sq = this.queue;
            if (sq != null) {
                sq.clear();
            }
        }
    }

    public static final class EqualCoordinator<T>
    extends DeferredScalarSubscription<Boolean>
    implements EqualCoordinatorHelper {
        private static final long serialVersionUID = -6178010334400373240L;
        final BiPredicate<? super T, ? super T> comparer;
        final EqualSubscriber<T> first;
        final EqualSubscriber<T> second;
        final AtomicThrowable error;
        final AtomicInteger wip;
        T v1;
        T v2;

        public EqualCoordinator(Subscriber<? super Boolean> actual, int prefetch, BiPredicate<? super T, ? super T> comparer) {
            super(actual);
            this.comparer = comparer;
            this.wip = new AtomicInteger();
            this.first = new EqualSubscriber(this, prefetch);
            this.second = new EqualSubscriber(this, prefetch);
            this.error = new AtomicThrowable();
        }

        void subscribe(Publisher<? extends T> source1, Publisher<? extends T> source2) {
            source1.subscribe(this.first);
            source2.subscribe(this.second);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.first.cancel();
            this.second.cancel();
            if (this.wip.getAndIncrement() == 0) {
                this.first.clear();
                this.second.clear();
            }
        }

        void cancelAndClear() {
            this.first.cancel();
            this.first.clear();
            this.second.cancel();
            this.second.clear();
        }

        @Override
        public void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            block6: do {
                Throwable ex;
                FusedQueue q1 = this.first.queue;
                FusedQueue q2 = this.second.queue;
                if (q1 != null && q2 != null) {
                    while (true) {
                        boolean c;
                        boolean e2;
                        if (this.isCancelled()) {
                            this.first.clear();
                            this.second.clear();
                            return;
                        }
                        ex = (Throwable)this.error.get();
                        if (ex != null) {
                            this.cancelAndClear();
                            this.actual.onError(this.error.terminate());
                            return;
                        }
                        boolean d1 = this.first.done;
                        Object a = this.v1;
                        if (a == null) {
                            try {
                                a = q1.poll();
                            }
                            catch (Throwable exc) {
                                Exceptions.throwIfFatal((Throwable)exc);
                                this.cancelAndClear();
                                this.error.addThrowable(exc);
                                this.actual.onError(this.error.terminate());
                                return;
                            }
                            this.v1 = a;
                        }
                        boolean e1 = a == null;
                        boolean d2 = this.second.done;
                        Object b = this.v2;
                        if (b == null) {
                            try {
                                b = q2.poll();
                            }
                            catch (Throwable exc) {
                                Exceptions.throwIfFatal((Throwable)exc);
                                this.cancelAndClear();
                                this.error.addThrowable(exc);
                                this.actual.onError(this.error.terminate());
                                return;
                            }
                            this.v2 = b;
                        }
                        boolean bl = e2 = b == null;
                        if (d1 && d2 && e1 && e2) {
                            this.complete(true);
                            return;
                        }
                        if (d1 && d2 && e1 != e2) {
                            this.cancelAndClear();
                            this.complete(false);
                            return;
                        }
                        if (e1 || e2) continue block6;
                        try {
                            c = this.comparer.test(a, b);
                        }
                        catch (Throwable exc) {
                            Exceptions.throwIfFatal((Throwable)exc);
                            this.cancelAndClear();
                            this.error.addThrowable(exc);
                            this.actual.onError(this.error.terminate());
                            return;
                        }
                        if (!c) {
                            this.cancelAndClear();
                            this.complete(false);
                            return;
                        }
                        this.v1 = null;
                        this.v2 = null;
                        this.first.request();
                        this.second.request();
                    }
                }
                if (this.isCancelled()) {
                    this.first.clear();
                    this.second.clear();
                    return;
                }
                ex = (Throwable)this.error.get();
                if (ex == null) continue;
                this.cancelAndClear();
                this.actual.onError(this.error.terminate());
                return;
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        @Override
        public void innerError(Throwable t) {
            if (this.error.addThrowable(t)) {
                this.drain();
            } else {
                RxJavaCommonPlugins.onError((Throwable)t);
            }
        }
    }

    public static interface EqualCoordinatorHelper {
        public void drain();

        public void innerError(Throwable var1);
    }
}

