/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.Disposable;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.Scheduler;
import io.reactivex.common.exceptions.MissingBackpressureException;
import io.reactivex.common.internal.disposables.SequentialDisposable;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import io.reactivex.flowable.internal.utils.BackpressureHelper;
import io.reactivex.flowable.subscribers.SerializedSubscriber;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableThrottleFirstTimed<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;

    public FlowableThrottleFirstTimed(Flowable<T> source, long timeout, TimeUnit unit, Scheduler scheduler) {
        super(source);
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new DebounceTimedSubscriber<T>(new SerializedSubscriber<T>(s), this.timeout, this.unit, this.scheduler.createWorker()));
    }

    static final class DebounceTimedSubscriber<T>
    extends AtomicLong
    implements RelaxedSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = -9102637559663639004L;
        final Subscriber<? super T> actual;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        Subscription s;
        final SequentialDisposable timer = new SequentialDisposable();
        volatile boolean gate;
        boolean done;

        DebounceTimedSubscriber(Subscriber<? super T> actual, long timeout, TimeUnit unit, Scheduler.Worker worker) {
            this.actual = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (!this.gate) {
                this.gate = true;
                long r = this.get();
                if (r == 0L) {
                    this.done = true;
                    this.cancel();
                    this.actual.onError((Throwable)new MissingBackpressureException("Could not deliver value due to lack of requests"));
                    return;
                }
                this.actual.onNext(t);
                BackpressureHelper.produced(this, 1L);
                Disposable d = (Disposable)this.timer.get();
                if (d != null) {
                    d.dispose();
                }
                this.timer.replace(this.worker.schedule((Runnable)this, this.timeout, this.unit));
            }
        }

        @Override
        public void run() {
            this.gate = false;
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
            this.worker.dispose();
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
            this.worker.dispose();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this, n);
            }
        }

        public void cancel() {
            this.s.cancel();
            this.worker.dispose();
        }
    }
}

