/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.ConditionalSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.CompositeException;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.BiFunction;
import io.reactivex.common.functions.Function;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.ParallelFailureHandling;
import io.reactivex.flowable.ParallelFlowable;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelMapTry<T, R>
extends ParallelFlowable<R> {
    final ParallelFlowable<T> source;
    final Function<? super T, ? extends R> mapper;
    final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;

    public ParallelMapTry(ParallelFlowable<T> source, Function<? super T, ? extends R> mapper, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
        this.source = source;
        this.mapper = mapper;
        this.errorHandler = errorHandler;
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            Subscriber<? super R> a = subscribers[i];
            parents[i] = a instanceof ConditionalSubscriber ? new ParallelMapTryConditionalSubscriber<T, R>((ConditionalSubscriber)a, this.mapper, this.errorHandler) : new ParallelMapTrySubscriber<T, R>(a, this.mapper, this.errorHandler);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelMapTryConditionalSubscriber<T, R>
    implements ConditionalSubscriber<T>,
    Subscription {
        final ConditionalSubscriber<? super R> actual;
        final Function<? super T, ? extends R> mapper;
        final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;
        Subscription s;
        boolean done;

        ParallelMapTryConditionalSubscriber(ConditionalSubscriber<? super R> actual, Function<? super T, ? extends R> mapper, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            this.actual = actual;
            this.mapper = mapper;
            this.errorHandler = errorHandler;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t) && !this.done) {
                this.s.request(1L);
            }
        }

        public boolean tryOnNext(T t) {
            Object v;
            if (this.done) {
                return false;
            }
            long retries = 0L;
            block9: while (true) {
                try {
                    v = ObjectHelper.requireNonNull((Object)this.mapper.apply(t), (String)"The mapper returned a null value");
                }
                catch (Throwable ex) {
                    ParallelFailureHandling h;
                    Exceptions.throwIfFatal((Throwable)ex);
                    try {
                        h = (ParallelFailureHandling)((Object)ObjectHelper.requireNonNull((Object)this.errorHandler.apply((Object)(++retries), (Object)ex), (String)"The errorHandler returned a null item"));
                    }
                    catch (Throwable exc) {
                        Exceptions.throwIfFatal((Throwable)exc);
                        this.cancel();
                        this.onError((Throwable)new CompositeException(new Throwable[]{ex, exc}));
                        return false;
                    }
                    switch (h) {
                        case RETRY: {
                            continue block9;
                        }
                        case SKIP: {
                            return false;
                        }
                        case STOP: {
                            this.cancel();
                            this.onComplete();
                            return false;
                        }
                    }
                    this.cancel();
                    this.onError(ex);
                    return false;
                }
                break;
            }
            return this.actual.tryOnNext(v);
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }
    }

    static final class ParallelMapTrySubscriber<T, R>
    implements ConditionalSubscriber<T>,
    Subscription {
        final Subscriber<? super R> actual;
        final Function<? super T, ? extends R> mapper;
        final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;
        Subscription s;
        boolean done;

        ParallelMapTrySubscriber(Subscriber<? super R> actual, Function<? super T, ? extends R> mapper, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            this.actual = actual;
            this.mapper = mapper;
            this.errorHandler = errorHandler;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t) && !this.done) {
                this.s.request(1L);
            }
        }

        public boolean tryOnNext(T t) {
            Object v;
            if (this.done) {
                return false;
            }
            long retries = 0L;
            block9: while (true) {
                try {
                    v = ObjectHelper.requireNonNull((Object)this.mapper.apply(t), (String)"The mapper returned a null value");
                }
                catch (Throwable ex) {
                    ParallelFailureHandling h;
                    Exceptions.throwIfFatal((Throwable)ex);
                    try {
                        h = (ParallelFailureHandling)((Object)ObjectHelper.requireNonNull((Object)this.errorHandler.apply((Object)(++retries), (Object)ex), (String)"The errorHandler returned a null item"));
                    }
                    catch (Throwable exc) {
                        Exceptions.throwIfFatal((Throwable)exc);
                        this.cancel();
                        this.onError((Throwable)new CompositeException(new Throwable[]{ex, exc}));
                        return false;
                    }
                    switch (h) {
                        case RETRY: {
                            continue block9;
                        }
                        case SKIP: {
                            return false;
                        }
                        case STOP: {
                            this.cancel();
                            this.onComplete();
                            return false;
                        }
                    }
                    this.cancel();
                    this.onError(ex);
                    return false;
                }
                break;
            }
            this.actual.onNext(v);
            return true;
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }
    }
}

