/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.CompositeException;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.Action;
import io.reactivex.common.functions.Consumer;
import io.reactivex.common.functions.LongConsumer;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.ParallelFlowable;
import io.reactivex.flowable.internal.subscriptions.EmptySubscription;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelPeek<T>
extends ParallelFlowable<T> {
    final ParallelFlowable<T> source;
    final Consumer<? super T> onNext;
    final Consumer<? super T> onAfterNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    final Action onAfterTerminated;
    final Consumer<? super Subscription> onSubscribe;
    final LongConsumer onRequest;
    final Action onCancel;

    public ParallelPeek(ParallelFlowable<T> source, Consumer<? super T> onNext, Consumer<? super T> onAfterNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminated, Consumer<? super Subscription> onSubscribe, LongConsumer onRequest, Action onCancel) {
        this.source = source;
        this.onNext = (Consumer)ObjectHelper.requireNonNull(onNext, (String)"onNext is null");
        this.onAfterNext = (Consumer)ObjectHelper.requireNonNull(onAfterNext, (String)"onAfterNext is null");
        this.onError = (Consumer)ObjectHelper.requireNonNull(onError, (String)"onError is null");
        this.onComplete = (Action)ObjectHelper.requireNonNull((Object)onComplete, (String)"onComplete is null");
        this.onAfterTerminated = (Action)ObjectHelper.requireNonNull((Object)onAfterTerminated, (String)"onAfterTerminated is null");
        this.onSubscribe = (Consumer)ObjectHelper.requireNonNull(onSubscribe, (String)"onSubscribe is null");
        this.onRequest = (LongConsumer)ObjectHelper.requireNonNull((Object)onRequest, (String)"onRequest is null");
        this.onCancel = (Action)ObjectHelper.requireNonNull((Object)onCancel, (String)"onCancel is null");
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            parents[i] = new ParallelPeekSubscriber<T>(subscribers[i], this);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelPeekSubscriber<T>
    implements RelaxedSubscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        final ParallelPeek<T> parent;
        Subscription s;
        boolean done;

        ParallelPeekSubscriber(Subscriber<? super T> actual, ParallelPeek<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        public void request(long n) {
            try {
                this.parent.onRequest.accept(n);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                RxJavaCommonPlugins.onError((Throwable)ex);
            }
            this.s.request(n);
        }

        public void cancel() {
            try {
                this.parent.onCancel.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                RxJavaCommonPlugins.onError((Throwable)ex);
            }
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                try {
                    this.parent.onSubscribe.accept((Object)s);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    s.cancel();
                    this.actual.onSubscribe((Subscription)EmptySubscription.INSTANCE);
                    this.onError(ex);
                    return;
                }
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (!this.done) {
                try {
                    this.parent.onNext.accept(t);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.onError(ex);
                    return;
                }
                this.actual.onNext(t);
                try {
                    this.parent.onAfterNext.accept(t);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.onError(ex);
                }
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            try {
                this.parent.onError.accept((Object)t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                t = new CompositeException(new Throwable[]{t, ex});
            }
            this.actual.onError(t);
            try {
                this.parent.onAfterTerminated.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                RxJavaCommonPlugins.onError((Throwable)ex);
            }
        }

        public void onComplete() {
            if (!this.done) {
                this.done = true;
                try {
                    this.parent.onComplete.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.actual.onError(ex);
                    return;
                }
                this.actual.onComplete();
                try {
                    this.parent.onAfterTerminated.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    RxJavaCommonPlugins.onError((Throwable)ex);
                }
            }
        }
    }
}

