/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.BiFunction;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.ParallelFlowable;
import io.reactivex.flowable.internal.subscribers.DeferredScalarSubscriber;
import io.reactivex.flowable.internal.subscriptions.EmptySubscription;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.Callable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelReduce<T, R>
extends ParallelFlowable<R> {
    final ParallelFlowable<? extends T> source;
    final Callable<R> initialSupplier;
    final BiFunction<R, ? super T, R> reducer;

    public ParallelReduce(ParallelFlowable<? extends T> source, Callable<R> initialSupplier, BiFunction<R, ? super T, R> reducer) {
        this.source = source;
        this.initialSupplier = initialSupplier;
        this.reducer = reducer;
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            Object initialValue;
            try {
                initialValue = ObjectHelper.requireNonNull(this.initialSupplier.call(), (String)"The initialSupplier returned a null value");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.reportError(subscribers, ex);
                return;
            }
            parents[i] = new ParallelReduceSubscriber<T, Object>(subscribers[i], initialValue, this.reducer);
        }
        this.source.subscribe(parents);
    }

    void reportError(Subscriber<?>[] subscribers, Throwable ex) {
        for (Subscriber<?> s : subscribers) {
            EmptySubscription.error(ex, s);
        }
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelReduceSubscriber<T, R>
    extends DeferredScalarSubscriber<T, R> {
        private static final long serialVersionUID = 8200530050639449080L;
        final BiFunction<R, ? super T, R> reducer;
        R accumulator;
        boolean done;

        ParallelReduceSubscriber(Subscriber<? super R> subscriber, R initialValue, BiFunction<R, ? super T, R> reducer) {
            super(subscriber);
            this.accumulator = initialValue;
            this.reducer = reducer;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (!this.done) {
                Object v;
                try {
                    v = ObjectHelper.requireNonNull((Object)this.reducer.apply(this.accumulator, t), (String)"The reducer returned a null value");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.cancel();
                    this.onError(ex);
                    return;
                }
                this.accumulator = v;
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.accumulator = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                R a = this.accumulator;
                this.accumulator = null;
                this.complete(a);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

