/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.functions.BiFunction;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.ParallelFlowable;
import io.reactivex.flowable.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelReduceFull<T>
extends Flowable<T> {
    final ParallelFlowable<? extends T> source;
    final BiFunction<T, T, T> reducer;

    public ParallelReduceFull(ParallelFlowable<? extends T> source, BiFunction<T, T, T> reducer) {
        this.source = source;
        this.reducer = reducer;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        ParallelReduceFullMainSubscriber<? super T> parent = new ParallelReduceFullMainSubscriber<T>(s, this.source.parallelism(), this.reducer);
        s.onSubscribe(parent);
        this.source.subscribe((Subscriber<? super T>[])parent.subscribers);
    }

    static final class SlotPair<T>
    extends AtomicInteger {
        private static final long serialVersionUID = 473971317683868662L;
        T first;
        T second;
        final AtomicInteger releaseIndex = new AtomicInteger();

        SlotPair() {
        }

        int tryAcquireSlot() {
            int acquired;
            do {
                if ((acquired = this.get()) < 2) continue;
                return -1;
            } while (!this.compareAndSet(acquired, acquired + 1));
            return acquired;
        }

        boolean releaseSlot() {
            return this.releaseIndex.incrementAndGet() == 2;
        }
    }

    static final class ParallelReduceFullInnerSubscriber<T>
    extends AtomicReference<Subscription>
    implements RelaxedSubscriber<T> {
        private static final long serialVersionUID = -7954444275102466525L;
        final ParallelReduceFullMainSubscriber<T> parent;
        final BiFunction<T, T, T> reducer;
        T value;
        boolean done;

        ParallelReduceFullInnerSubscriber(ParallelReduceFullMainSubscriber<T> parent, BiFunction<T, T, T> reducer) {
            this.parent = parent;
            this.reducer = reducer;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (!this.done) {
                Object v = this.value;
                if (v == null) {
                    this.value = t;
                } else {
                    try {
                        v = ObjectHelper.requireNonNull((Object)this.reducer.apply(v, t), (String)"The reducer returned a null value");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        ((Subscription)this.get()).cancel();
                        this.onError(ex);
                        return;
                    }
                    this.value = v;
                }
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.parent.innerError(t);
        }

        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.parent.innerComplete(this.value);
            }
        }

        void cancel() {
            SubscriptionHelper.cancel(this);
        }
    }

    static final class ParallelReduceFullMainSubscriber<T>
    extends DeferredScalarSubscription<T> {
        private static final long serialVersionUID = -5370107872170712765L;
        final ParallelReduceFullInnerSubscriber<T>[] subscribers;
        final BiFunction<T, T, T> reducer;
        final AtomicReference<SlotPair<T>> current = new AtomicReference();
        final AtomicInteger remaining = new AtomicInteger();
        final AtomicReference<Throwable> error = new AtomicReference();

        ParallelReduceFullMainSubscriber(Subscriber<? super T> subscriber, int n, BiFunction<T, T, T> reducer) {
            super(subscriber);
            ParallelReduceFullInnerSubscriber[] a = new ParallelReduceFullInnerSubscriber[n];
            for (int i = 0; i < n; ++i) {
                a[i] = new ParallelReduceFullInnerSubscriber<T>(this, reducer);
            }
            this.subscribers = a;
            this.reducer = reducer;
            this.remaining.lazySet(n);
        }

        SlotPair<T> addValue(T value) {
            int c;
            SlotPair<T> curr;
            while (true) {
                if ((curr = this.current.get()) == null && !this.current.compareAndSet(null, curr = new SlotPair())) {
                    continue;
                }
                c = curr.tryAcquireSlot();
                if (c >= 0) break;
                this.current.compareAndSet(curr, null);
            }
            if (c == 0) {
                curr.first = value;
            } else {
                curr.second = value;
            }
            if (curr.releaseSlot()) {
                this.current.compareAndSet(curr, null);
                return curr;
            }
            return null;
        }

        @Override
        public void cancel() {
            for (ParallelReduceFullInnerSubscriber<T> inner : this.subscribers) {
                inner.cancel();
            }
        }

        void innerError(Throwable ex) {
            if (this.error.compareAndSet(null, ex)) {
                this.cancel();
                this.actual.onError(ex);
            } else if (ex != this.error.get()) {
                RxJavaCommonPlugins.onError((Throwable)ex);
            }
        }

        void innerComplete(T value) {
            SlotPair<T> sp;
            if (value != null) {
                while ((sp = this.addValue(value)) != null) {
                    try {
                        value = ObjectHelper.requireNonNull((Object)this.reducer.apply(sp.first, sp.second), (String)"The reducer returned a null value");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        this.innerError(ex);
                        return;
                    }
                }
            }
            if (this.remaining.decrementAndGet() == 0) {
                sp = this.current.get();
                this.current.lazySet(null);
                if (sp != null) {
                    this.complete(sp.first);
                } else {
                    this.actual.onComplete();
                }
            }
        }
    }
}

