/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.ConditionalSubscriber;
import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.Scheduler;
import io.reactivex.common.exceptions.MissingBackpressureException;
import io.reactivex.flowable.ParallelFlowable;
import io.reactivex.flowable.internal.queues.SpscArrayQueue;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import io.reactivex.flowable.internal.utils.BackpressureHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelRunOn<T>
extends ParallelFlowable<T> {
    final ParallelFlowable<? extends T> source;
    final Scheduler scheduler;
    final int prefetch;

    public ParallelRunOn(ParallelFlowable<? extends T> parent, Scheduler scheduler, int prefetch) {
        this.source = parent;
        this.scheduler = scheduler;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        int prefetch = this.prefetch;
        for (int i = 0; i < n; ++i) {
            Subscriber<? super T> a = subscribers[i];
            Scheduler.Worker w = this.scheduler.createWorker();
            SpscArrayQueue q = new SpscArrayQueue(prefetch);
            parents[i] = a instanceof ConditionalSubscriber ? new RunOnConditionalSubscriber((ConditionalSubscriber)a, prefetch, q, w) : new RunOnSubscriber<T>(a, prefetch, q, w);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class RunOnConditionalSubscriber<T>
    extends BaseRunOnSubscriber<T> {
        private static final long serialVersionUID = 1075119423897941642L;
        final ConditionalSubscriber<? super T> actual;

        RunOnConditionalSubscriber(ConditionalSubscriber<? super T> actual, int prefetch, SpscArrayQueue<T> queue, Scheduler.Worker worker) {
            super(prefetch, queue, worker);
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request((long)this.prefetch);
            }
        }

        @Override
        public void run() {
            int missed = 1;
            int c = this.consumed;
            SpscArrayQueue q = this.queue;
            ConditionalSubscriber<? super T> a = this.actual;
            int lim = this.limit;
            while (true) {
                int w;
                long r = this.requested.get();
                long e = 0L;
                while (e != r) {
                    int p;
                    boolean empty;
                    Throwable ex;
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    boolean d = this.done;
                    if (d && (ex = this.error) != null) {
                        q.clear();
                        a.onError(ex);
                        this.worker.dispose();
                        return;
                    }
                    Object v = q.poll();
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        a.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    if (empty) break;
                    if (a.tryOnNext(v)) {
                        ++e;
                    }
                    if ((p = ++c) != lim) continue;
                    c = 0;
                    this.s.request((long)p);
                }
                if (e == r) {
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    if (this.done) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            q.clear();
                            a.onError(ex);
                            this.worker.dispose();
                            return;
                        }
                        if (q.isEmpty()) {
                            a.onComplete();
                            this.worker.dispose();
                            return;
                        }
                    }
                }
                if (e != 0L && r != Long.MAX_VALUE) {
                    this.requested.addAndGet(-e);
                }
                if ((w = this.get()) == missed) {
                    this.consumed = c;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }
    }

    static final class RunOnSubscriber<T>
    extends BaseRunOnSubscriber<T> {
        private static final long serialVersionUID = 1075119423897941642L;
        final Subscriber<? super T> actual;

        RunOnSubscriber(Subscriber<? super T> actual, int prefetch, SpscArrayQueue<T> queue, Scheduler.Worker worker) {
            super(prefetch, queue, worker);
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request((long)this.prefetch);
            }
        }

        @Override
        public void run() {
            int missed = 1;
            int c = this.consumed;
            SpscArrayQueue q = this.queue;
            Subscriber<? super T> a = this.actual;
            int lim = this.limit;
            while (true) {
                int w;
                long e;
                long r = this.requested.get();
                for (e = 0L; e != r; ++e) {
                    int p;
                    boolean empty;
                    Throwable ex;
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    boolean d = this.done;
                    if (d && (ex = this.error) != null) {
                        q.clear();
                        a.onError(ex);
                        this.worker.dispose();
                        return;
                    }
                    Object v = q.poll();
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        a.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    if (empty) break;
                    a.onNext(v);
                    if ((p = ++c) != lim) continue;
                    c = 0;
                    this.s.request((long)p);
                }
                if (e == r) {
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    if (this.done) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            q.clear();
                            a.onError(ex);
                            this.worker.dispose();
                            return;
                        }
                        if (q.isEmpty()) {
                            a.onComplete();
                            this.worker.dispose();
                            return;
                        }
                    }
                }
                if (e != 0L && r != Long.MAX_VALUE) {
                    this.requested.addAndGet(-e);
                }
                if ((w = this.get()) == missed) {
                    this.consumed = c;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }
    }

    static abstract class BaseRunOnSubscriber<T>
    extends AtomicInteger
    implements RelaxedSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = 9222303586456402150L;
        final int prefetch;
        final int limit;
        final SpscArrayQueue<T> queue;
        final Scheduler.Worker worker;
        Subscription s;
        volatile boolean done;
        Throwable error;
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        int consumed;

        BaseRunOnSubscriber(int prefetch, SpscArrayQueue<T> queue, Scheduler.Worker worker) {
            this.prefetch = prefetch;
            this.queue = queue;
            this.limit = prefetch - (prefetch >> 2);
            this.worker = worker;
        }

        public final void onNext(T t) {
            if (this.done) {
                return;
            }
            if (!this.queue.offer(t)) {
                this.s.cancel();
                this.onError((Throwable)new MissingBackpressureException("Queue is full?!"));
                return;
            }
            this.schedule();
        }

        public final void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.error = t;
            this.done = true;
            this.schedule();
        }

        public final void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.schedule();
        }

        public final void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.schedule();
            }
        }

        public final void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                this.worker.dispose();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        final void schedule() {
            if (this.getAndIncrement() == 0) {
                this.worker.schedule((Runnable)this);
            }
        }
    }
}

