/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.subscribers;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.internal.utils.BlockingHelper;
import io.reactivex.common.internal.utils.ExceptionHelper;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.CountDownLatch;
import org.reactivestreams.Subscription;

public abstract class BlockingBaseSubscriber<T>
extends CountDownLatch
implements RelaxedSubscriber<T> {
    T value;
    Throwable error;
    Subscription s;
    volatile boolean cancelled;

    public BlockingBaseSubscriber() {
        super(1);
    }

    public final void onSubscribe(Subscription s) {
        if (SubscriptionHelper.validate(this.s, s)) {
            this.s = s;
            if (!this.cancelled) {
                s.request(Long.MAX_VALUE);
                if (this.cancelled) {
                    this.s = SubscriptionHelper.CANCELLED;
                    s.cancel();
                }
            }
        }
    }

    public final void onComplete() {
        this.countDown();
    }

    public final T blockingGet() {
        Throwable e;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex) {
                Subscription s = this.s;
                this.s = SubscriptionHelper.CANCELLED;
                if (s != null) {
                    s.cancel();
                }
                throw ExceptionHelper.wrapOrThrow((Throwable)ex);
            }
        }
        if ((e = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow((Throwable)e);
        }
        return this.value;
    }
}

