/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.subscriptions;

import hu.akarnokd.reactivestreams.extensions.FusedQueueSubscription;
import io.reactivex.common.annotations.Nullable;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Subscriber;

public final class ScalarSubscription<T>
extends AtomicInteger
implements FusedQueueSubscription<T> {
    private static final long serialVersionUID = -3830916580126663321L;
    final T value;
    final Subscriber<? super T> subscriber;
    static final int NO_REQUEST = 0;
    static final int REQUESTED = 1;
    static final int CANCELLED = 2;

    public ScalarSubscription(Subscriber<? super T> subscriber, T value) {
        this.subscriber = subscriber;
        this.value = value;
    }

    public void request(long n) {
        if (!SubscriptionHelper.validate(n)) {
            return;
        }
        if (this.compareAndSet(0, 1)) {
            Subscriber<? super T> s = this.subscriber;
            s.onNext(this.value);
            if (this.get() != 2) {
                s.onComplete();
            }
        }
    }

    public void cancel() {
        this.lazySet(2);
    }

    public boolean isCancelled() {
        return this.get() == 2;
    }

    public boolean offer(T e) {
        throw new UnsupportedOperationException("Should not be called!");
    }

    @Nullable
    public T poll() {
        if (this.get() == 0) {
            this.lazySet(1);
            return this.value;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.get() != 0;
    }

    public void clear() {
        this.lazySet(1);
    }

    public int requestFusion(int mode) {
        return mode & 1;
    }
}

