/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.subscribers;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.Disposable;
import io.reactivex.common.internal.disposables.ListCompositeDisposable;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public abstract class ResourceSubscriber<T>
implements RelaxedSubscriber<T>,
Disposable {
    private final AtomicReference<Subscription> s = new AtomicReference();
    private final ListCompositeDisposable resources = new ListCompositeDisposable();
    private final AtomicLong missedRequested = new AtomicLong();

    public final void add(Disposable resource) {
        ObjectHelper.requireNonNull((Object)resource, (String)"resource is null");
        this.resources.add(resource);
    }

    public final void onSubscribe(Subscription s) {
        if (SubscriptionHelper.deferredSetOnce(this.s, this.missedRequested, s)) {
            this.onStart();
        }
    }

    protected void onStart() {
        this.request(Long.MAX_VALUE);
    }

    protected final void request(long n) {
        SubscriptionHelper.deferredRequest(this.s, this.missedRequested, n);
    }

    public final void dispose() {
        if (SubscriptionHelper.cancel(this.s)) {
            this.resources.dispose();
        }
    }

    public final boolean isDisposed() {
        return SubscriptionHelper.isCancelled(this.s.get());
    }
}

