/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertopires.mail;

import io.github.albertopires.commons.GenericProperties;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class Mail {
    private Properties mailSettings;
    private Session session;
    private String userId;
    private String password;
    private String configFile;
    public static final String MAIL_FROM = "mail.from";
    public static final String MAIL_FROM_NAME = "mail.from.name";
    public static final String MAIL_SUBJECT = "mail.subject";
    public static final String MSG_FILE = "file.message";
    public static final String ATTCH_FILE = "file.attachment";
    public static final String RCPT_LIST = "rcpt.list";
    private static final String PARAM_USER = "java-utils.user";
    private static final String PARAM_PASS = "java-utils.password";
    private static final String PARAM_CONFIG = "java-utils.config";

    public Mail() {
        this.init();
        this.userId = this.mailSettings.getProperty(PARAM_USER);
        this.password = this.mailSettings.getProperty(PARAM_PASS);
    }

    public Mail(String userId, String password) {
        this.init();
        this.userId = userId;
        this.password = password;
    }

    private void init() {
        this.loadConfig();
        this.session = Session.getDefaultInstance((Properties)this.mailSettings, null);
    }

    private void loadConfig() {
        Properties config = new Properties();
        this.configFile = System.getProperties().getProperty(PARAM_CONFIG);
        try {
            if (this.configFile == null) {
                this.configFile = "sample_smtp.properties";
            }
            FileInputStream fi = new FileInputStream(this.configFile);
            config.load(fi);
        }
        catch (IOException e) {
            System.err.println("Fail to open configuration file : " + this.configFile);
            System.exit(1);
        }
        this.mailSettings = System.getProperties();
        this.mailSettings.putAll((Map<?, ?>)config);
    }

    public final void sendTextMail(GenericProperties param) throws AddressException, MessagingException, UnsupportedEncodingException, IOException {
        MimeMessage message = new MimeMessage(this.session);
        message.setFrom((Address)new InternetAddress(param.getProperty(MAIL_FROM), param.getProperty(MAIL_FROM_NAME)));
        List<String> rcptList = param.getList(RCPT_LIST);
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(rcptList.get(0)));
        for (int i = 1; i < rcptList.size(); ++i) {
            message.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(rcptList.get(i)));
        }
        message.setSubject(param.getProperty(MAIL_SUBJECT));
        String emailBody = new String(Files.readAllBytes(Paths.get(param.getProperty(MSG_FILE), new String[0])));
        message.setContent((Object)emailBody, "text/html");
        Transport transport = this.session.getTransport("smtp");
        transport.connect(this.mailSettings.getProperty("mail.smtp.relay"), this.userId, this.password);
        transport.sendMessage((Message)message, message.getAllRecipients());
        transport.close();
    }

    public final void sendTextandAttachmentEmail(GenericProperties param) throws AddressException, MessagingException, UnsupportedEncodingException, IOException {
        String attchFile;
        MimeBodyPart messageBodyPart;
        MimeMessage message = new MimeMessage(this.session);
        message.setFrom((Address)new InternetAddress(param.getProperty(MAIL_FROM), param.getProperty(MAIL_FROM_NAME)));
        List<String> rcptList = param.getList(RCPT_LIST);
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(rcptList.get(0)));
        for (int i = 1; i < rcptList.size(); ++i) {
            message.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(rcptList.get(i)));
        }
        message.setSubject(param.getProperty(MAIL_SUBJECT));
        MimeMultipart multipart = new MimeMultipart();
        String textFileName = param.getProperty(MSG_FILE);
        if (textFileName != null) {
            messageBodyPart = new MimeBodyPart();
            String messageText = new String(Files.readAllBytes(Paths.get(textFileName, new String[0])));
            messageBodyPart.setText(messageText);
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        if ((attchFile = param.getProperty(ATTCH_FILE)) != null) {
            messageBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(attchFile);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            String[] aux = attchFile.split("/");
            messageBodyPart.setFileName(aux[aux.length - 1]);
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        message.setContent((Multipart)multipart);
        Transport transport = this.session.getTransport("smtp");
        transport.connect(this.mailSettings.getProperty("mail.smtp.relay"), this.userId, this.password);
        transport.sendMessage((Message)message, message.getAllRecipients());
        transport.close();
    }
}

