/*
 * Decompiled with CFR 0.152.
 */
package com.github.angleshq.angles.api.requests;

import com.github.angleshq.angles.api.exceptions.AnglesServerException;
import com.github.angleshq.angles.api.models.Platform;
import com.github.angleshq.angles.api.models.execution.AddPlatforms;
import com.github.angleshq.angles.api.models.execution.CreateExecution;
import com.github.angleshq.angles.api.models.execution.Execution;
import com.github.angleshq.angles.api.requests.BaseRequests;
import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;

public class ExecutionRequests
extends BaseRequests {
    private String basePath = "execution";

    public ExecutionRequests(String baseUrl) {
        super(baseUrl);
    }

    public Execution create(CreateExecution createExecution) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONPost(this.basePath, createExecution);
        return this.processResponse(response, Execution.class);
    }

    public Execution[] get() throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONGet(this.basePath);
        return this.processResponse(response, Execution[].class);
    }

    public Execution get(String executionId) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONGet(this.basePath + "/" + executionId);
        return this.processResponse(response, Execution.class);
    }

    public Boolean delete(String executionId) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendDelete(this.basePath + "/" + executionId);
        if (response.getStatusLine().getStatusCode() == 200) {
            return true;
        }
        this.processErrorResponse(response);
        return false;
    }

    public Execution update(Execution execution) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONPut(this.basePath + "/" + execution.getId(), execution);
        return this.processResponse(response, Execution.class);
    }

    public Execution platforms(String executionId, Platform ... platforms) throws IOException, AnglesServerException {
        AddPlatforms addPlatformsRequest = new AddPlatforms();
        for (Platform platform : platforms) {
            addPlatformsRequest.addPlatform(platform);
        }
        CloseableHttpResponse response = this.sendJSONPut(this.basePath + "/" + executionId + "/platforms", addPlatformsRequest);
        return this.processResponse(response, Execution.class);
    }
}

