/*
 * Decompiled with CFR 0.152.
 */
package com.github.angleshq.angles.api.requests;

import com.github.angleshq.angles.api.exceptions.AnglesServerException;
import com.github.angleshq.angles.api.models.Team;
import com.github.angleshq.angles.api.requests.BaseRequests;
import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;

public class TeamRequests
extends BaseRequests {
    private String basePath = "team";

    public TeamRequests(String baseUrl) {
        super(baseUrl);
    }

    public Team create(Team team) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONPost(this.basePath, team);
        return this.processResponse(response, Team.class);
    }

    public Team[] get() throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONGet(this.basePath);
        return this.processResponse(response, Team[].class);
    }

    public Team get(String teamId) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONGet(this.basePath + "/" + teamId);
        return this.processResponse(response, Team.class);
    }

    public Boolean delete(String teamId) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendDelete(this.basePath + "/" + teamId);
        if (response.getStatusLine().getStatusCode() == 200) {
            return true;
        }
        this.processErrorResponse(response);
        return false;
    }

    public Team update(Team team) throws IOException, AnglesServerException {
        CloseableHttpResponse response = this.sendJSONPut(this.basePath + "/" + team.getId(), team);
        return this.processResponse(response, Team.class);
    }
}

