/*
 * Decompiled with CFR 0.152.
 */
package com.github.angleshq.angles.api.requests;

import com.github.angleshq.angles.api.exceptions.AnglesServerException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public abstract class BaseRequests {
    protected CloseableHttpClient client = HttpClients.createDefault();
    protected String baseUrl;
    protected Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").create();

    protected BaseRequests(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected CloseableHttpResponse sendJSONPost(String path, Object message) throws IOException {
        HttpPost httpPost = new HttpPost(this.baseUrl.concat(path));
        StringEntity entity = new StringEntity(this.gson.toJson(message));
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-type", "application/json");
        return this.client.execute((HttpUriRequest)httpPost);
    }

    protected CloseableHttpResponse sendMultiPartEntity(String path, Map<String, String> headers, HttpEntity entity) throws IOException {
        HttpPost httpPost = new HttpPost(this.baseUrl.concat(path));
        for (String key : headers.keySet()) {
            httpPost.setHeader(key, headers.get(key));
        }
        httpPost.setHeader("Accept", "application/json");
        httpPost.setEntity(entity);
        return this.client.execute((HttpUriRequest)httpPost);
    }

    protected CloseableHttpResponse sendJSONGet(String path) throws IOException {
        HttpGet httpGet = new HttpGet(this.baseUrl.concat(path));
        httpGet.setHeader("Accept", "application/json");
        return this.client.execute((HttpUriRequest)httpGet);
    }

    protected CloseableHttpResponse sendJSONGet(String path, Map<String, Object> parameters) throws IOException, URISyntaxException {
        URIBuilder builder = new URIBuilder(this.baseUrl.concat(path));
        if (parameters != null && parameters.size() > 0) {
            for (String key : parameters.keySet()) {
                builder.setParameter(key, parameters.get(key).toString());
            }
        }
        HttpGet httpGet = new HttpGet(builder.build());
        httpGet.setHeader("Accept", "application/json");
        return this.client.execute((HttpUriRequest)httpGet);
    }

    protected CloseableHttpResponse sendDelete(String path) throws IOException {
        HttpDelete httpDelete = new HttpDelete(this.baseUrl.concat(path));
        httpDelete.setHeader("Accept", "application/json");
        return this.client.execute((HttpUriRequest)httpDelete);
    }

    protected CloseableHttpResponse sendJSONPut(String path, Object message) throws IOException {
        HttpPut httpPut = new HttpPut(this.baseUrl.concat(path));
        StringEntity entity = new StringEntity(this.gson.toJson(message));
        httpPut.setEntity((HttpEntity)entity);
        httpPut.setHeader("Accept", "application/json");
        httpPut.setHeader("Content-type", "application/json");
        return this.client.execute((HttpUriRequest)httpPut);
    }

    protected String getDefaultErrorMessage(CloseableHttpResponse response) {
        String errorMessage = "";
        try {
            String bodyString = EntityUtils.toString((HttpEntity)response.getEntity());
            JsonObject jsonResponse = (JsonObject)this.gson.fromJson(bodyString, JsonObject.class);
            errorMessage = jsonResponse.get("message").toString();
        }
        catch (IOException exc) {
            try {
                errorMessage = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (IOException exception) {
                errorMessage = "Unable to extract error message from response due to [" + exception.getMessage() + "]";
            }
        }
        return errorMessage;
    }

    protected <T> T processResponse(CloseableHttpResponse response, Class<T> responseClass) throws IOException, AnglesServerException {
        if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201) {
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            return (T)this.gson.fromJson(responseBody, responseClass);
        }
        this.processErrorResponse(response);
        return null;
    }

    protected void processErrorResponse(CloseableHttpResponse response) throws AnglesServerException {
        if (response.getStatusLine().getStatusCode() == 404) {
            throw new AnglesServerException(404, this.getDefaultErrorMessage(response));
        }
        if (response.getStatusLine().getStatusCode() == 409) {
            throw new AnglesServerException(409, this.getDefaultErrorMessage(response));
        }
        if (response.getStatusLine().getStatusCode() == 422) {
            throw new AnglesServerException(422, this.getDefaultErrorMessage(response));
        }
        throw new AnglesServerException(500, this.getDefaultErrorMessage(response));
    }
}

