/*
 * Decompiled with CFR 0.152.
 */
package com.github.angleshq.angles.util;

import com.github.angleshq.angles.AnglesReporter;
import com.github.angleshq.angles.AnglesReporterInterface;
import com.github.angleshq.angles.exceptions.AnglesPropertyNotGivenException;
import org.apache.commons.lang3.StringUtils;

public class AnglesReporterUtils {
    private static AnglesReporterInterface anglesReporter;
    private static String runName;
    private static String team;
    private static String component;
    private static String environment;

    public static AnglesReporterInterface initialiseAnglesTestParameters() throws AnglesPropertyNotGivenException {
        String enabled = "false";
        try {
            enabled = AnglesReporterUtils.getAnglesPropertyFromSystem("angles.enabled");
        }
        catch (AnglesPropertyNotGivenException anglesPropertyNotGivenException) {
            // empty catch block
        }
        if (enabled.equals("true")) {
            anglesReporter = AnglesReporter.getInstance(AnglesReporterUtils.getAnglesPropertyFromSystem("angles.url") + "/rest/api/v1.0/");
            runName = AnglesReporterUtils.getAnglesPropertyFromSystem("angles.runName");
            team = AnglesReporterUtils.getAnglesPropertyFromSystem("angles.team");
            component = AnglesReporterUtils.getAnglesPropertyFromSystem("angles.component");
            environment = AnglesReporterUtils.getAnglesPropertyFromSystem("angles.environment");
        } else {
            AnglesReporter.setEnabled(false);
            anglesReporter = AnglesReporter.getInstance(null);
        }
        return anglesReporter;
    }

    public static String getAnglesPropertyFromSystem(String property) throws AnglesPropertyNotGivenException {
        String propertyValue = System.getProperty(property);
        if (StringUtils.isBlank((CharSequence)propertyValue)) {
            throw new AnglesPropertyNotGivenException("Detected that property [" + property + "] was not given. Please add this mandatory property as a system property");
        }
        return propertyValue;
    }

    public static AnglesReporterInterface getAnglesReporter() {
        return anglesReporter;
    }

    public static String getRunName() {
        return runName;
    }

    public static String getTeam() {
        return team;
    }

    public static String getComponent() {
        return component;
    }

    public static String getEnvironment() {
        return environment;
    }
}

