package com.github.azbh111.utils.java.io.jar;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;

/**
 * @author pyz
 * @date 2018/9/15 上午10:46
 */
public class JarUtils {
    private static final String osName = System.getProperty("os.name").toLowerCase();

    public static Path getJar(Class clazz) throws Exception {
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URI location = (codeSource != null) ? codeSource.getLocation().toURI() : null;
        String path = (location != null) ? location.getSchemeSpecificPart() : null;
        if (path == null) {
            throw new IllegalStateException("Unable to determine code source archive");
        }
        if (osName.contains("windows") && path.startsWith("/")) {
            path = path.substring(1);
        }
        return Paths.get(path);
    }

}
