package com.github.azbh111.utils.java.lang;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author: zyp
 * @date: 2020/6/20 9:46 上午
 */
public class Triple<L, M, R> implements Comparable<Triple<L, M, R>>, Serializable {

    private static final long serialVersionUID = 1L;
    private L left;
    private M middle;
    private R right;

    public static <L, M, R> Triple<L, M, R> of(final L left, final M middle, final R right) {
        return new Triple<>(left, middle, right);
    }

    public static <L, M, R> int compare(Triple<L, M, R> left, Triple<L, M, R> right) {
        if (left == null) {
            if (right != null) {
                return -1;
            }
            return 0;
        } else if (right == null) {
            return 1;
        }
        return left.compareTo(right);
    }

    public Triple() {
    }

    public Triple(L left, M middle, R right) {
        this.left = left;
        this.middle = middle;
        this.right = right;
    }

    /**
     * 左右反转
     * 返回新的
     *
     * @return
     */
    public Triple<R, M, L> reverse() {
        return new Triple<>(right, middle, left);
    }

    /**
     * 自身的left和right进行交换
     */
    public void reverseSelf() {
        Object tmp = left;
        left = (L) right;
        right = (R) tmp;
    }

    public L getLeft() {
        return left;
    }

    public void setLeft(L left) {
        this.left = left;
    }

    public M getMiddle() {
        return middle;
    }

    public void setMiddle(M middle) {
        this.middle = middle;
    }

    public R getRight() {
        return right;
    }

    public void setRight(R right) {
        this.right = right;
    }

    @Override
    public int compareTo(final Triple<L, M, R> o) {
        if (this == o) {
            return 0;
        }
        L left1 = this.left;
        L left2 = o.left;
        if (left1 == null) {
            if (left2 != null) {
                return -1;
            }
//            都是null
        } else if (left2 == null) {
            return 1;
        } else {
//            都不是null
            int c = ((Comparable) left1).compareTo(left2);
            if (c != 0) {
                return c;
            }
        }

        M middle1 = this.middle;
        M middle2 = o.middle;
        if (middle1 == null) {
            if (middle2 != null) {
                return -1;
            }
//            null
        } else if (middle2 == null) {
            return 1;
        } else {
//            都不是null
            int c = ((Comparable) middle1).compareTo(middle2);
            if (c != 0) {
                return c;
            }
        }

        R right1 = this.right;
        R right2 = o.right;
        if (right1 == null) {
            if (right2 != null) {
                return -1;
            }
//            都是null
            return 0;
        } else if (right2 == null) {
            return 1;
        } else {
//            都不是null
            return ((Comparable) right1).compareTo(right2);
        }
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Triple<?, ?, ?> triple = (Triple<?, ?, ?>) o;
        return Objects.equals(left, triple.left) &&
                Objects.equals(middle, triple.middle) &&
                Objects.equals(right, triple.right);
    }

    @Override
    public int hashCode() {
        return Objects.hash(left, middle, right);
    }

    @Override
    public String toString() {
        return "{" + left + ", " + middle + ", " + right + '}';
    }
}
