package com.github.azbh111.utils.java.string;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.Vector;

public class Tokenizer {
    public static char NO_COMMENT_CHARACTER = '\0';
    private Vector _indexToTokenEntries;
    private int _currentIndex;

    public Tokenizer(String str, String delimiter) {
        this(str, new String[]{delimiter});
    }

    public Tokenizer(String str, String delimiters[]) {
        this(str, delimiters, false, false, NO_COMMENT_CHARACTER, NO_COMMENT_CHARACTER);
    }

    public Tokenizer(String str, String delimiters[], boolean returnDelimiters, boolean returnEmptyStrings, char commentStartCharacter, char commentEndCharacter) {
        _currentIndex = 0;
        StringBuilder buf = new StringBuilder(str);
        TreeMap<Double, String> indexToDelimiterMap = new TreeMap();
        for (int i = 0; i < delimiters.length; i++) {
            getDelimiterIndizes(buf, delimiters[i], commentStartCharacter, commentEndCharacter, indexToDelimiterMap);
        }

        TreeMap<Double, String> indexToTokenMap = new TreeMap();
        getTokenIndizes(buf, indexToDelimiterMap, indexToTokenMap, returnEmptyStrings);
        if (returnDelimiters) {
            indexToTokenMap.putAll(indexToDelimiterMap);
        }
        _indexToTokenEntries = new Vector();
        _indexToTokenEntries.addAll(indexToTokenMap.entrySet());
    }

    public boolean hasMoreTokens() {
        return _currentIndex < _indexToTokenEntries.size();
    }

    public String nextToken() {
        if (_currentIndex >= _indexToTokenEntries.size()) {
            throw new NoSuchElementException();
        } else {
            java.util.Map.Entry entry = (java.util.Map.Entry) _indexToTokenEntries.get(_currentIndex);
            String returnString = (String) entry.getValue();
            _currentIndex++;
            return returnString;
        }
    }

    public int leftTokens() {
        return _indexToTokenEntries.size() - _currentIndex;
    }

    private static void getTokenIndizes(StringBuilder buf, TreeMap<Double, String> indexToDelimiterMap, TreeMap<Double, String> tokenMap, boolean returnEmptyStrings) {
        Iterator it = indexToDelimiterMap.entrySet().iterator();
        int lastStopIndex;
        int currentStopIndex;
        String delimiterString;
        for (lastStopIndex = 0; it.hasNext(); lastStopIndex = currentStopIndex + delimiterString.length()) {
            java.util.Map.Entry entry = (java.util.Map.Entry) it.next();
            currentStopIndex = (int) ((Double) entry.getKey()).floatValue();
            putTokenIfNecessary(buf, tokenMap, returnEmptyStrings, lastStopIndex, currentStopIndex);
            delimiterString = (String) entry.getValue();
        }

        putTokenIfNecessary(buf, tokenMap, returnEmptyStrings, lastStopIndex, buf.length());
    }

    private static void putTokenIfNecessary(StringBuilder buf, TreeMap<Double, String> tokenMap, boolean returnEmptyStrings, int lastStopIndex, int currentStopIndex) {
        String returnString = buf.substring(lastStopIndex, currentStopIndex);
        if (returnString.trim().equals("")) {
            if (returnEmptyStrings) {
                tokenMap.put(new Double((double) lastStopIndex - 0.5D), returnString);
            }
        } else {
            tokenMap.put(new Double(lastStopIndex), returnString);
        }
    }

    private static void getDelimiterIndizes(StringBuilder buf, String delimiter, char commentStartCharacter, char commentEndCharacter, TreeMap<Double, String> indexToDelimiterMap) {
        int delimiterIndex = 0;
        boolean isComment = false;
        if (commentEndCharacter == NO_COMMENT_CHARACTER) {
            commentEndCharacter = commentStartCharacter;
        }
        for (int i = 0; i < buf.length(); i++) {
            if (buf.charAt(i) == commentStartCharacter && !isComment || buf.charAt(i) == commentEndCharacter && isComment) {
                isComment = !isComment;
                delimiterIndex = 0;
                continue;
            }
            if (isComment) {
                continue;
            }
            if (buf.charAt(i) == delimiter.charAt(delimiterIndex)) {
                if (++delimiterIndex == delimiter.length()) {
                    int delimiterStartIndex = (i - delimiterIndex) + 1;
                    indexToDelimiterMap.put(new Double(delimiterStartIndex), delimiter);
                    delimiterIndex = 0;
                }
            } else {
                delimiterIndex = 0;
            }
        }
    }
}
