/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.array;

import com.github.azbh111.utils.java.reflect.ClassUtils;

public class ArrayUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];

    public static int indexOf(boolean[] array, boolean valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0, Integer.MAX_VALUE);
    }

    public static int indexOf(boolean[] array, boolean valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        for (int i = startIndex; i < toIndex; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] array, boolean valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    public static int lastIndexOf(boolean[] array, boolean valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        for (int i = startIndex; i > toIndex; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] array, char valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0, Integer.MAX_VALUE);
    }

    public static int indexOf(char[] array, char valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        for (int i = startIndex; i < toIndex; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    public static int lastIndexOf(char[] array, char valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        for (int i = startIndex; i > toIndex; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0, Integer.MAX_VALUE);
    }

    public static int indexOf(byte[] array, byte valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        for (int i = startIndex; i < toIndex; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array, byte valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    public static int lastIndexOf(byte[] array, byte valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        for (int i = startIndex; i > toIndex; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short[] array, short valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0, Integer.MAX_VALUE);
    }

    public static int indexOf(short[] array, short valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        for (int i = startIndex; i < toIndex; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] array, short valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    public static int lastIndexOf(short[] array, short valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        for (int i = startIndex; i > toIndex; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0, Integer.MAX_VALUE);
    }

    public static int indexOf(int[] array, int valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        for (int i = startIndex; i < toIndex; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    public static int lastIndexOf(int[] array, int valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        for (int i = startIndex; i > toIndex; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] array, long valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0, Integer.MAX_VALUE);
    }

    public static int indexOf(long[] array, long valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        for (int i = startIndex; i < toIndex; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(long[] array, long valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    public static int lastIndexOf(long[] array, long valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        for (int i = startIndex; i > toIndex; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float[] array, float valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0, Integer.MAX_VALUE);
    }

    public static int indexOf(float[] array, float valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        for (int i = startIndex; i < toIndex; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(float[] array, float valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    public static int lastIndexOf(float[] array, float valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        for (int i = startIndex; i > toIndex; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0, Integer.MAX_VALUE);
    }

    public static int indexOf(double[] array, double valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex > array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        for (int i = startIndex; i < toIndex; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    public static int lastIndexOf(double[] array, double valueToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        for (int i = startIndex; i > toIndex; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double valueToFind, double tolerance) {
        return ArrayUtils.indexOf(array, valueToFind, 0, Integer.MAX_VALUE, tolerance);
    }

    public static int indexOf(double[] array, double valueToFind, int startIndex, int toIndex, double tolerance) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex >= array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        double min = valueToFind - tolerance;
        double max = valueToFind + tolerance;
        for (int i = startIndex; i < toIndex; ++i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double valueToFind, double tolerance) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE, Integer.MIN_VALUE, tolerance);
    }

    public static int lastIndexOf(double[] array, double valueToFind, int startIndex, int toIndex, double tolerance) {
        if (array == null) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (toIndex < -1) {
            toIndex = -1;
        }
        if (startIndex <= toIndex) {
            return -1;
        }
        double min = valueToFind - tolerance;
        double max = valueToFind + tolerance;
        for (int i = startIndex; i > toIndex; --i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object[] array, Object objectToFind) {
        return ArrayUtils.indexOf(array, objectToFind, 0, Integer.MAX_VALUE);
    }

    public static int indexOf(Object[] array, Object objectToFind, int startIndex, int toIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (toIndex >= array.length) {
            toIndex = array.length;
        }
        if (startIndex >= toIndex) {
            return -1;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i < toIndex; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < toIndex; ++i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(Object[] array, Object objectToFind) {
        return ArrayUtils.lastIndexOf(array, objectToFind, Integer.MAX_VALUE, -1);
    }

    public static int lastIndexOf(Object[] array, Object objectToFind, int startIndex, int toIndex) {
        block7: {
            block6: {
                if (array == null) {
                    return -1;
                }
                if (startIndex >= array.length) {
                    startIndex = array.length - 1;
                }
                if (toIndex < -1) {
                    toIndex = -1;
                }
                if (startIndex <= toIndex) {
                    return -1;
                }
                if (objectToFind != null) break block6;
                for (int i = startIndex; i > toIndex; --i) {
                    if (array[i] != null) continue;
                    return i;
                }
                break block7;
            }
            if (!array.getClass().getComponentType().isInstance(objectToFind)) break block7;
            for (int i = startIndex; i > toIndex; --i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static Boolean[] wrap(boolean[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] result = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] ? Boolean.TRUE : Boolean.FALSE;
        }
        return result;
    }

    public static Character[] wrap(char[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] result = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Character.valueOf(array[i]);
        }
        return result;
    }

    public static Byte[] wrap(byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Short[] wrap(short[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] result = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Integer[] wrap(int[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Long[] wrap(long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Float[] wrap(float[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    public static Double[] wrap(double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static boolean[] unwrap(Boolean[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static boolean[] unwrap(Boolean[] array, boolean valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            Boolean b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static char[] unwrap(Character[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].charValue();
        }
        return result;
    }

    public static char[] unwrap(Character[] array, char valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            Character b = array[i];
            result[i] = b == null ? valueForNull : b.charValue();
        }
        return result;
    }

    public static byte[] unwrap(Byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static byte[] unwrap(Byte[] array, byte valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            Byte b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static short[] unwrap(Short[] array, short valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            Short b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static short[] unwrap(Short[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static int[] unwrap(Integer[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static int[] unwrap(Integer[] array, int valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            Integer b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static long[] unwrap(Long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static long[] unwrap(Long[] array, long valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            Long b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static float[] unwrap(Float[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].floatValue();
        }
        return result;
    }

    public static float[] unwrap(Float[] array, float valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            Float b = array[i];
            result[i] = b == null ? valueForNull : b.floatValue();
        }
        return result;
    }

    public static double[] unwrap(Double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static double[] unwrap(Double[] array, double valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            Double b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Object unwrapArray(Object array) {
        if (array == null) {
            return null;
        }
        Class<?> ct = array.getClass().getComponentType();
        Class<?> pt = ClassUtils.unwrapPrimitive(ct);
        if (pt == null) {
            return null;
        }
        if (pt == Boolean.TYPE) {
            return ArrayUtils.unwrap((Boolean[])array);
        }
        if (pt == Character.TYPE) {
            return ArrayUtils.unwrap((Character[])array);
        }
        if (pt == Byte.TYPE) {
            return ArrayUtils.unwrap((Byte[])array);
        }
        if (pt == Short.TYPE) {
            return ArrayUtils.unwrap((Short[])array);
        }
        if (pt == Integer.TYPE) {
            return ArrayUtils.unwrap((Integer[])array);
        }
        if (pt == Long.TYPE) {
            return ArrayUtils.unwrap((Long[])array);
        }
        if (pt == Float.TYPE) {
            return ArrayUtils.unwrap((Float[])array);
        }
        if (pt == Double.TYPE) {
            return ArrayUtils.unwrap((Double[])array);
        }
        return null;
    }

    public static Object wrapArray(Object array) {
        if (array == null) {
            return null;
        }
        Class<?> pt = array.getClass().getComponentType();
        if (!pt.isPrimitive()) {
            return null;
        }
        if (pt == Boolean.TYPE) {
            return ArrayUtils.wrap((boolean[])array);
        }
        if (pt == Character.TYPE) {
            return ArrayUtils.wrap((char[])array);
        }
        if (pt == Byte.TYPE) {
            return ArrayUtils.wrap((byte[])array);
        }
        if (pt == Short.TYPE) {
            return ArrayUtils.wrap((short[])array);
        }
        if (pt == Integer.TYPE) {
            return ArrayUtils.wrap((int[])array);
        }
        if (pt == Long.TYPE) {
            return ArrayUtils.wrap((long[])array);
        }
        if (pt == Float.TYPE) {
            return ArrayUtils.wrap((float[])array);
        }
        if (pt == Double.TYPE) {
            return ArrayUtils.wrap((double[])array);
        }
        return null;
    }

    public static int indexOfMaxValue(int[] arr) {
        return ArrayUtils.indexOfMaxValue(arr, 0, arr.length);
    }

    public static int indexOfMaxValue(int[] arr, int fromIndex, int toIndex) {
        int maxIndex = -1;
        int maxValue = Integer.MIN_VALUE;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (maxValue >= arr[i]) continue;
            maxValue = arr[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public static void swap(byte[] arr, int leftIndex, int rightIndex) {
        byte tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }

    public static void swap(short[] arr, int leftIndex, int rightIndex) {
        short tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }

    public static void swap(int[] arr, int leftIndex, int rightIndex) {
        int tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }

    public static void swap(long[] arr, int leftIndex, int rightIndex) {
        long tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }

    public static void swap(float[] arr, int leftIndex, int rightIndex) {
        float tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }

    public static void swap(double[] arr, int leftIndex, int rightIndex) {
        double tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }

    public static void swap(boolean[] arr, int leftIndex, int rightIndex) {
        boolean tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }

    public static void swap(char[] arr, int leftIndex, int rightIndex) {
        char tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }

    public static <T> void swap(T[] arr, int leftIndex, int rightIndex) {
        T tmp = arr[leftIndex];
        arr[leftIndex] = arr[rightIndex];
        arr[rightIndex] = tmp;
    }

    public static <T> void reverse(T[] arr) {
        ArrayUtils.reverse(arr, 0, arr.length);
    }

    public static <T> void reverse(T[] arr, int fromIndex, int toIndex) {
        --toIndex;
        while (fromIndex < toIndex) {
            ArrayUtils.swap(arr, fromIndex++, toIndex--);
        }
    }

    public static void reverse(byte[] arr) {
        ArrayUtils.reverse(arr, 0, arr.length);
    }

    public static void reverse(byte[] arr, int fromIndex, int toIndex) {
        --toIndex;
        while (fromIndex < toIndex) {
            ArrayUtils.swap(arr, fromIndex++, toIndex--);
        }
    }

    public static void reverse(short[] arr) {
        ArrayUtils.reverse(arr, 0, arr.length);
    }

    public static void reverse(short[] arr, int fromIndex, int toIndex) {
        --toIndex;
        while (fromIndex < toIndex) {
            ArrayUtils.swap(arr, fromIndex++, toIndex--);
        }
    }

    public static void reverse(int[] arr) {
        ArrayUtils.reverse(arr, 0, arr.length);
    }

    public static void reverse(int[] arr, int fromIndex, int toIndex) {
        --toIndex;
        while (fromIndex < toIndex) {
            ArrayUtils.swap(arr, fromIndex++, toIndex--);
        }
    }

    public static void reverse(long[] arr) {
        ArrayUtils.reverse(arr, 0, arr.length);
    }

    public static void reverse(long[] arr, int fromIndex, int toIndex) {
        --toIndex;
        while (fromIndex < toIndex) {
            ArrayUtils.swap(arr, fromIndex++, toIndex--);
        }
    }

    public static void reverse(float[] arr) {
        ArrayUtils.reverse(arr, 0, arr.length);
    }

    public static void reverse(float[] arr, int fromIndex, int toIndex) {
        --toIndex;
        while (fromIndex < toIndex) {
            ArrayUtils.swap(arr, fromIndex++, toIndex--);
        }
    }

    public static void reverse(double[] arr) {
        ArrayUtils.reverse(arr, 0, arr.length);
    }

    public static void reverse(double[] arr, int fromIndex, int toIndex) {
        --toIndex;
        while (fromIndex < toIndex) {
            ArrayUtils.swap(arr, fromIndex++, toIndex--);
        }
    }

    public static void reverse(boolean[] arr) {
        ArrayUtils.reverse(arr, 0, arr.length);
    }

    public static void reverse(boolean[] arr, int fromIndex, int toIndex) {
        --toIndex;
        while (fromIndex < toIndex) {
            ArrayUtils.swap(arr, fromIndex++, toIndex--);
        }
    }

    public static void reverse(char[] arr) {
        ArrayUtils.reverse(arr, 0, arr.length);
    }

    public static void reverse(char[] arr, int fromIndex, int toIndex) {
        --toIndex;
        while (fromIndex < toIndex) {
            ArrayUtils.swap(arr, fromIndex++, toIndex--);
        }
    }

    public static String toString(Object[] array) {
        if (array == null || array.length == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (array.getClass().getComponentType() == String.class) {
            Object o = array[0];
            if (o == null) {
                sb.append("null");
            } else {
                sb.append("\"").append(o).append("\"");
            }
            sb.append("\"").append(array[0]);
            int length = array.length;
            for (int i = 1; i < length; ++i) {
                o = array[i];
                if (o == null) {
                    sb.append(", null");
                    continue;
                }
                sb.append(", \"").append(o).append("\"");
            }
        } else {
            sb.append(array[0]);
            int length = array.length;
            for (int i = 1; i < length; ++i) {
                sb.append(", ");
                sb.append(array[i]);
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

