/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.code;

import com.github.azbh111.utils.java.charset.Charsets;
import com.github.azbh111.utils.java.io.IOUtils;
import com.github.azbh111.utils.java.io.stream.CounterInputStream;
import com.github.azbh111.utils.java.io.stream.CounterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;

public class Base64Utils {
    public static String encodeToString(byte[] bytes) {
        return Base64Utils.encodeToString(bytes, false);
    }

    public static String encodeToString(byte[] bytes, boolean url) {
        return new String(Base64Utils.encode(bytes, url), Charsets.UTF_8);
    }

    public static byte[] encode(byte[] bytes) {
        return Base64Utils.encode(bytes, false);
    }

    public static byte[] encode(byte[] bytes, boolean url) {
        return Base64Utils.getEncoder(url).encode(bytes);
    }

    public static byte[] decode(byte[] bytes) {
        return Base64Utils.decode(bytes, false);
    }

    public static byte[] decode(byte[] bytes, boolean url) {
        return Base64Utils.getDecoder(url).decode(bytes);
    }

    public static byte[] decode(String base64) {
        return Base64Utils.decode(base64, false);
    }

    public static byte[] decode(String base64, boolean url) {
        return Base64Utils.getDecoder(url).decode(base64);
    }

    public static Counter encodeLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        return Base64Utils.encodeLarge(inputStream, outputStream, false);
    }

    public static Counter encodeLarge(InputStream inputStream, OutputStream outputStream, boolean url) throws IOException {
        CounterOutputStream counterOutputStream = new CounterOutputStream(outputStream);
        OutputStream base64OutputStream = Base64Utils.wrap(counterOutputStream, url);
        long input = IOUtils.copy(inputStream, base64OutputStream);
        long output = counterOutputStream.getCount();
        return new Counter(input, output);
    }

    public static Counter decodeLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        return Base64Utils.decodeLarge(inputStream, outputStream, false);
    }

    public static Counter decodeLarge(InputStream inputStream, OutputStream outputStream, boolean url) throws IOException {
        CounterInputStream counterInputStream = new CounterInputStream(inputStream);
        InputStream base64InputStream = Base64Utils.wrap(counterInputStream, url);
        long input = counterInputStream.getCount();
        long output = IOUtils.copy(base64InputStream, outputStream);
        return new Counter(input, output);
    }

    public static InputStream wrap(InputStream inputStream) {
        return Base64Utils.wrap(inputStream, false);
    }

    public static InputStream wrap(InputStream inputStream, boolean url) {
        return Base64Utils.getDecoder(url).wrap(inputStream);
    }

    public static OutputStream wrap(OutputStream outputStream) {
        return Base64Utils.wrap(outputStream, false);
    }

    public static OutputStream wrap(OutputStream outputStream, boolean url) {
        return Base64Utils.getEncoder(url).wrap(outputStream);
    }

    public static Base64.Encoder getEncoder(boolean url) {
        return url ? Base64.getUrlEncoder() : Base64.getEncoder();
    }

    public static Base64.Decoder getDecoder(boolean url) {
        return url ? Base64.getUrlDecoder() : Base64.getDecoder();
    }

    public static class Counter {
        private final long input;
        private final long output;

        public Counter(long input, long output) {
            this.input = input;
            this.output = output;
        }

        public long getInput() {
            return this.input;
        }

        public long getOutput() {
            return this.output;
        }
    }
}

