/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.money;

import java.math.BigDecimal;

public class MoneyUtils {
    private static final BigDecimal one_hundred = BigDecimal.valueOf(100L);
    private static final String CN_ZERO = "\u96f6";
    private static final String CN_ONE = "\u58f9";
    private static final String CN_TWO = "\u8d30";
    private static final String CN_THREE = "\u53c1";
    private static final String CN_FOUR = "\u8086";
    private static final String CN_FIVE = "\u4f0d";
    private static final String CN_SIX = "\u9646";
    private static final String CN_SEVEN = "\u67d2";
    private static final String CN_EIGHT = "\u634c";
    private static final String CN_NINE = "\u7396";
    private static final String CN_TEN = "\u62fe";
    private static final String CN_HUNDRED = "\u4f70";
    private static final String CN_THOUSAND = "\u4edf";
    private static final String CN_TEN_THOUSAND = "\u4e07";
    private static final String CN_HUNDRED_MILLION = "\u4ebf";
    private static final String CN_SYMBOL = "";
    private static final String CN_DOLLAR = "\u5143";
    private static final String CN_TEN_CENT = "\u89d2";
    private static final String CN_CENT = "\u5206";
    private static final String CN_INTEGER = "\u6574";
    private static final String[] digits = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] radices = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};
    private static final String[] bigRadices = new String[]{"", "\u4e07", "\u4ebf"};
    private static final String[] decimals = new String[]{"\u89d2", "\u5206"};
    private static final BigDecimal MAXIMUM_NUMBER = BigDecimal.valueOf(9.999999999999E10);

    public static String toChineseUpperCase(BigDecimal money) {
        int d;
        int i;
        String str;
        StringBuilder outputCharacters = new StringBuilder();
        if (money.signum() < 0) {
            outputCharacters.append("\u8d1f");
            money = money.abs();
        }
        if (money.compareTo(MAXIMUM_NUMBER) > 0) {
            throw new IllegalArgumentException("Too large a number to convert!");
        }
        long integral = money.longValue();
        int decimal = money.subtract(BigDecimal.valueOf(integral)).multiply(one_hundred).intValue();
        if (integral > 0L) {
            int zeroCount = 0;
            str = Long.toString(integral);
            for (i = 0; i < str.length(); ++i) {
                int p = str.length() - i - 1;
                d = str.charAt(i) - 48;
                int quotient = p / 4;
                int modulus = p % 4;
                if (d == 0) {
                    ++zeroCount;
                } else {
                    if (zeroCount > 0) {
                        outputCharacters.append(digits[0]);
                    }
                    zeroCount = 0;
                    outputCharacters.append(digits[d]).append(radices[modulus]);
                }
                if (modulus != 0 || zeroCount >= 4) continue;
                outputCharacters.append(bigRadices[quotient]);
            }
            outputCharacters.append(CN_DOLLAR);
        }
        if (decimal > 0) {
            str = decimal < 10 ? "0" + Long.toString(decimal) : Long.toString(decimal);
            for (i = 0; i < str.length(); ++i) {
                d = str.charAt(i) - 48;
                int ds = str.charAt(str.length() - 1) - 48;
                if (d == 0) {
                    if (ds == 0) continue;
                    outputCharacters.append(digits[d]);
                    continue;
                }
                outputCharacters.append(digits[d]).append(decimals[i]);
            }
        }
        if (outputCharacters.length() == 0) {
            outputCharacters.append(CN_ZERO).append(CN_DOLLAR);
        }
        if (decimal == 0) {
            outputCharacters.append(CN_INTEGER);
        }
        return outputCharacters.toString();
    }

    public static long[] average(long total, int num) {
        boolean negative;
        boolean bl = negative = total < 0L;
        if (negative) {
            total = -total;
        }
        long[] averages = new long[num];
        if (num == 1) {
            averages[0] = total;
        } else {
            long average = total / (long)num;
            long left = total - average * (long)num;
            for (int i = 0; i < num; ++i) {
                averages[i] = (long)i < left ? average + 1L : average;
            }
        }
        if (negative) {
            for (int i = 0; i < averages.length; ++i) {
                averages[i] = -averages[i];
            }
        }
        return averages;
    }
}

