/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.date;

import com.github.azbh111.utils.java.date.DateParseException;
import com.github.azbh111.utils.java.datetime.DateTimeUtils;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DateUtils {
    public static final Map<String, DateTimeFormatter> standardDateFormatters = new LinkedHashMap<String, DateTimeFormatter>();
    public static final int ZERO_DAY_OF_WEEK = LocalDate.of(1970, 1, 1).getDayOfWeek().getValue();
    public static final Clock SYSTEM_DEFAULT_ZONE_CLOCK = Clock.systemDefaultZone();
    public static final Clock UTC_CLOCK = Clock.systemUTC();
    public static final ZoneId SYSTEM_DEFAULT_ZONE_ID = SYSTEM_DEFAULT_ZONE_CLOCK.getZone();
    public static final ZoneId UTC_ZONE_ID = UTC_CLOCK.getZone();

    public static LocalDate from(TemporalAccessor temporal) {
        if (temporal instanceof LocalDate) {
            return (LocalDate)temporal;
        }
        if (temporal instanceof Instant) {
            return ((Instant)temporal).atZone(SYSTEM_DEFAULT_ZONE_ID).toLocalDate();
        }
        try {
            int year = temporal.get(ChronoField.YEAR);
            int month = temporal.get(ChronoField.MONTH_OF_YEAR);
            int day = temporal.get(ChronoField.DAY_OF_MONTH);
            return LocalDate.of(year, month, day);
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain LocalDateTime from TemporalAccessor: " + temporal + " of type " + temporal.getClass().getName(), ex);
        }
    }

    public static Date toDate(LocalDate ld) {
        return Date.from(ld.atStartOfDay().atZone(SYSTEM_DEFAULT_ZONE_ID).toInstant());
    }

    public static LocalDate from(Date date) {
        return date.toInstant().atZone(SYSTEM_DEFAULT_ZONE_ID).toLocalDate();
    }

    public static LocalDate now() {
        return LocalDate.now();
    }

    public static List<LocalDate> flatDate(LocalDate from, int days) {
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(days);
        for (int i = 0; i < days; ++i) {
            dates.add(from.plusDays(i));
        }
        return dates;
    }

    public static LocalDate firstDayOfWeek() {
        return DateUtils.firstDayOfWeek(DateUtils.now());
    }

    public static LocalDate firstDayOfWeek(Date d) {
        return DateUtils.firstDayOfWeek(DateUtils.from(d));
    }

    public static LocalDate firstDayOfWeek(LocalDate dt) {
        int dayOfWeek = dt.getDayOfWeek().getValue();
        if (dayOfWeek > 1) {
            return dt.minusDays(dayOfWeek - 1);
        }
        return dt;
    }

    public static LocalDate lastDayOfWeek() {
        return DateUtils.lastDayOfWeek(DateUtils.now());
    }

    public static LocalDate lastDayOfWeek(Date d) {
        return DateUtils.lastDayOfWeek(DateUtils.from(d));
    }

    public static LocalDate lastDayOfWeek(LocalDate d) {
        int dayOfWeek = d.getDayOfWeek().getValue();
        if (dayOfWeek < 7) {
            return d.plusDays(7 - dayOfWeek);
        }
        return d;
    }

    public static LocalDate firstDayOfMonth() {
        return DateUtils.firstDayOfMonth(DateUtils.now());
    }

    public static LocalDate firstDayOfMonth(Date d) {
        return DateUtils.firstDayOfMonth(DateUtils.from(d));
    }

    public static LocalDate firstDayOfMonth(LocalDate dt) {
        return dt.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDate lastDayOfMonth() {
        return DateUtils.lastDayOfMonth(DateUtils.now());
    }

    public static LocalDate lastDayOfMonth(Date d) {
        return DateUtils.lastDayOfMonth(DateUtils.from(d));
    }

    public static LocalDate lastDayOfMonth(LocalDate dt) {
        return dt.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDate firstDayOfYear() {
        return DateUtils.firstDayOfYear(DateUtils.now());
    }

    public static LocalDate firstDayOfYear(Date d) {
        return DateUtils.firstDayOfYear(DateUtils.from(d));
    }

    public static LocalDate firstDayOfYear(LocalDate dt) {
        return dt.with(TemporalAdjusters.firstDayOfYear());
    }

    public static LocalDate lastDayOfYear() {
        return DateUtils.lastDayOfYear(DateUtils.now());
    }

    public static LocalDate lastDayOfYear(Date d) {
        return DateUtils.lastDayOfYear(DateUtils.from(d));
    }

    public static LocalDate lastDayOfYear(LocalDate dt) {
        return dt.with(TemporalAdjusters.lastDayOfYear());
    }

    public static long toEpochDay() {
        return DateUtils.toEpochDay(DateUtils.now());
    }

    public static long toEpochDay(Date d) {
        return DateUtils.toEpochDay(DateUtils.from(d));
    }

    public static long toEpochDay(ChronoLocalDate d) {
        return d.toEpochDay();
    }

    public static LocalDate of(int epochDay) {
        return LocalDate.ofEpochDay(epochDay);
    }

    public static int toEpochWeek() {
        return DateUtils.toEpochWeek(DateUtils.now());
    }

    public static int toEpochWeek(Date d) {
        return DateUtils.toEpochWeek(DateUtils.from(d));
    }

    public static int toEpochWeek(ChronoLocalDate ld) {
        return (int)((ld.toEpochDay() + (long)ZERO_DAY_OF_WEEK - 1L) / 7L);
    }

    public static LocalDate of(int epochWeek, int dayOfWeek) {
        return DateUtils.of(epochWeek * 7 - ZERO_DAY_OF_WEEK + dayOfWeek);
    }

    public static int dayOfWeek() {
        return DateUtils.dayOfWeek(LocalDate.now());
    }

    public static int dayOfWeek(LocalDate ld) {
        return ld.getDayOfWeek().getValue();
    }

    public static int dayOfMonth() {
        return DateUtils.dayOfMonth(DateUtils.now());
    }

    public static int dayOfMonth(LocalDate ld) {
        return ld.getDayOfMonth();
    }

    public static int monthOfYear() {
        return DateUtils.monthOfYear(DateUtils.now());
    }

    public static int monthOfYear(LocalDate ld) {
        return ld.getMonthValue();
    }

    public static boolean isLeapYear() {
        return DateUtils.isLeapYear(DateUtils.now());
    }

    public static boolean isLeapYear(Date d) {
        return DateUtils.isLeapYear(DateUtils.from(d));
    }

    public static boolean isLeapYear(ChronoLocalDate d) {
        return d.isLeapYear();
    }

    public static int lengthOfMoneth() {
        return DateUtils.lengthOfMoneth(DateUtils.now());
    }

    public static int lengthOfMoneth(Date d) {
        return DateUtils.lengthOfMoneth(DateUtils.from(d));
    }

    public static int lengthOfMoneth(ChronoLocalDate d) {
        return d.lengthOfMonth();
    }

    public static int lengthOfYear() {
        return DateUtils.lengthOfYear(DateUtils.now());
    }

    public static int lengthOfYear(Date d) {
        return DateUtils.lengthOfYear(DateUtils.from(d));
    }

    public static int lengthOfYear(ChronoLocalDate d) {
        return d.lengthOfYear();
    }

    public static LocalDate parse(String datetimeStr, String format) {
        DateTimeFormatter f = DateTimeUtils.getOrCreateDateTimeFormatter(format);
        return LocalDate.parse(datetimeStr, f);
    }

    public static LocalDate tryParse(String str) {
        TemporalAccessor t = null;
        for (DateTimeFormatter formatter : standardDateFormatters.values()) {
            LocalDate dt;
            try {
                t = formatter.parse((CharSequence)str, Instant::from);
                dt = DateUtils.from(t);
            }
            catch (Throwable e1) {
                try {
                    t = formatter.parse(str);
                    dt = DateUtils.from(t);
                }
                catch (DateTimeParseException e2) {
                    continue;
                }
            }
            return dt;
        }
        throw new DateParseException("Unable to parse " + str + " to LocalDate");
    }

    public static boolean isSameDay(Date d1, Date d2) {
        return DateUtils.from(d1).equals(DateUtils.from(d2));
    }

    static {
        standardDateFormatters.put("ISO_LOCAL_DATE", DateTimeFormatter.ISO_LOCAL_DATE);
        standardDateFormatters.put("ISO_DATE", DateTimeFormatter.ISO_DATE);
        standardDateFormatters.put("ISO_OFFSET_DATE", DateTimeFormatter.ISO_OFFSET_DATE);
        standardDateFormatters.put("ISO_ORDINAL_DATE", DateTimeFormatter.ISO_ORDINAL_DATE);
        standardDateFormatters.put("ISO_WEEK_DATE", DateTimeFormatter.ISO_WEEK_DATE);
        standardDateFormatters.put("BASIC_ISO_DATE", DateTimeFormatter.BASIC_ISO_DATE);
    }
}

