package com.github.azbh111.utils.java.lang;

import java.util.function.Supplier;

/**
 *
 * @author pyz
 * @date 2019/5/4 4:03 PM
 */
public class ThreadLocalLazyField<T> {
    private final ThreadLocal<T> threadLocal = new ThreadLocal();
    private final Supplier<T> supplier;

    private ThreadLocalLazyField(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public static <T> ThreadLocalLazyField<T> from(Supplier<T> supplier) {
        return new ThreadLocalLazyField<>(supplier);
    }

    public T get() {
        T value = threadLocal.get();
        if (value == null) {
            value = supplier.get();
            threadLocal.set(value);
        }
        return value;
    }

    public ThreadLocalLazyField<T> set(T value) {
        threadLocal.set(value);
        return this;
    }
}
