/*
 * Copyright (c) 2014-2019, Deepspring Healthcare Inc. All rights reserved.
 */

package com.github.azbh111.utils.java.web.model;

import com.github.azbh111.utils.java.model.Res;
import com.github.azbh111.utils.java.model.ResStatusEnum;
import lombok.ToString;


@ToString(callSuper = true)
public class PageResponse<T> extends JsonResponse<T> {

    private static final long serialVersionUID = -8439068266525433175L;

    protected PageRes page;

    protected PageResponse() {
    }

    public static <T> PageResponse<T> from(Res<T> res) {
        PageResponse<T> jr = PageResponse.of(res.getStatus().getStatus(), res.getData());
        if (res.getErrorMsg() != null) {
            jr.setErrorMsg(res.getErrorMsg());
        } else if (res.getStatus().getDisplayMsg() != null) {
            jr.setErrorMsg(res.getStatus().getDisplayMsg());
        } else {
            jr.setErrorMsg(res.getStatus().getDesc());
        }
        return jr;
    }

    public static PageResponse success() {
        return new PageResponse();
    }

    public static <T> PageResponse<T> success(T data) {
        return of(ResStatusEnum.OK.getStatus(), data, null);
    }

    public static PageResponse fail(String errorMsg) {
        return of(ResStatusEnum.BAD_REQUEST.getStatus(), null, errorMsg);
    }

    public static PageResponse of(int status, String errorMsg) {
        return of(status, null, errorMsg);
    }

    public static <T> PageResponse<T> of(int status, T data) {
        return of(status, data, null);
    }

    public static <T> PageResponse<T> of(int status, T data, String errorMsg) {
        return PageResponse.<T>success()
                .setStatus(status)
                .setData(data)
                .setErrorMsg(errorMsg);
    }

    public PageResponse<T> apply(Res<T> res) {
        super.apply(res);
        return this;
    }

    public PageResponse<T> setStatus(int status) {
        this.status = status;
        return this;
    }

    public PageResponse<T> setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public PageResponse<T> setData(T data) {
        this.data = data;
        return this;
    }

    public PageRes getPage() {
        return page;
    }

    public PageResponse<T> setPage(PageRes page) {
        this.page = page;
        return this;
    }
}