/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.function;

import com.github.azbh111.utils.java.string.StringUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;

public class Generator {
    String template = "package lol.clann.utils.base.function;\n\n/**\n *\n * @author pyz\n * @date 2019/3/11 8:43 PM\n */\n@FunctionalInterface\npublic interface {usrc}2{utarget}Function{suffix} {\n    {returnType} apply({parameterType} in);\n}\n";
    List<String> types = new ArrayList<String>();
    Path dir = Paths.get(System.getProperty("user.dir") + "/src/main/java/lol/clann/utils/function", new String[0]);

    public Generator() {
        this.types.add(Byte.TYPE.getSimpleName());
        this.types.add(Short.TYPE.getSimpleName());
        this.types.add(Integer.TYPE.getSimpleName());
        this.types.add(Long.TYPE.getSimpleName());
        this.types.add(Float.TYPE.getSimpleName());
        this.types.add(Double.TYPE.getSimpleName());
        this.types.add(Boolean.TYPE.getSimpleName());
        this.types.add(Character.TYPE.getSimpleName());
        this.types.add(Object.class.getSimpleName());
    }

    public static void main(String[] args) throws IOException {
        new Generator().run();
    }

    private void run() throws IOException {
        for (String src : this.types) {
            for (String target : this.types) {
                if (src.equals("Object") && target.equals("Object")) continue;
                this.generate(src, target);
            }
        }
    }

    private void generate(String src, String target) throws IOException {
        String usrc = Generator.upperCaseFirstCharacter(src);
        String utarget = Generator.upperCaseFirstCharacter(target);
        String suffix = usrc.equals("Object") || utarget.equals("Object") ? "<T>" : "";
        String returnType = utarget.equals("Object") ? "T" : target;
        String parameterType = usrc.equals("Object") ? "T" : src;
        String fileName = "{usrc}2{utarget}Function".replace("{usrc}", usrc).replace("{utarget}", utarget) + ".java";
        String content = this.template.replace("{usrc}", usrc).replace("{utarget}", utarget).replace("{suffix}", suffix).replace("{returnType}", returnType).replace("{parameterType}", parameterType);
        Path file = this.dir.resolve(fileName);
        if (!Files.exists(file, new LinkOption[0])) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(content);
            Files.write(file, list, StandardOpenOption.CREATE_NEW);
        }
    }

    public static String upperCaseFirstCharacter(String str) {
        return Generator.changeFirstLetter(str, 1);
    }

    public static String lowerCaseFirstCharacter(String str) {
        return Generator.changeFirstLetter(str, -1);
    }

    public static String newStringUnsafe(char[] chars) {
        return StringUtils.newStringZeroCopy(chars);
    }

    private static String changeFirstLetter(String str, int flag) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        char[] chars = str.toCharArray();
        if (flag == 1) {
            chars[0] = Character.toUpperCase(chars[0]);
        } else if (flag == -1) {
            chars[0] = Character.toLowerCase(chars[0]);
        }
        String r = Generator.newStringUnsafe(chars);
        return r;
    }
}

