/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.lambda;

import com.github.azbh111.utils.java.exception.ExceptionUtils;
import com.github.azbh111.utils.java.lambda.SBiConsumer;
import com.github.azbh111.utils.java.lambda.SBiConsumerInfo;
import com.github.azbh111.utils.java.lambda.SBiFunction;
import com.github.azbh111.utils.java.lambda.SBiFunctionInfo;
import com.github.azbh111.utils.java.lambda.SConsumer;
import com.github.azbh111.utils.java.lambda.SConsumerInfo;
import com.github.azbh111.utils.java.lambda.SFunction;
import com.github.azbh111.utils.java.lambda.SFunctionInfo;
import com.github.azbh111.utils.java.lambda.SSerializable;
import com.github.azbh111.utils.java.lambda.SSupplier;
import com.github.azbh111.utils.java.lambda.SSupplierInfo;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LambdaUtils {
    private static ConcurrentHashMap<String, SerializedLambda> cache = new ConcurrentHashMap();
    private static Pattern SFunctionPattern = Pattern.compile("\\(L([\\w\\d$_/]+);\\)L([\\w\\d$_/]+);");
    private static Pattern SBiFunctionPattern = Pattern.compile("\\(L([\\w\\d$_/]+);L([\\w\\d$_/]+);\\)L([\\w\\d$_/]+);");
    private static Pattern SConsumerPattern = Pattern.compile("\\(L([\\w\\d$_/]+);\\)V");
    private static Pattern SBiConsumerPattern = Pattern.compile("\\(L([\\w\\d$_/]+);L([\\w\\d$_/]+);\\)V");
    private static Pattern SSupplierrPattern = Pattern.compile("\\(\\)L([\\w\\d$_/]+);");

    public static <P, R> SFunctionInfo parse(SFunction<P, R> lambda) {
        if (lambda == null) {
            return null;
        }
        SerializedLambda sl = LambdaUtils.getSerializedLambda(lambda);
        Matcher m = SFunctionPattern.matcher(sl.getInstantiatedMethodType());
        if (!m.find()) {
            throw new Error("can not resolve instantiatedMethodType: " + sl.getInstantiatedMethodType());
        }
        try {
            return new SFunctionInfo(Class.forName(m.group(1).replaceAll("/", ".")), Class.forName(m.group(2).replaceAll("/", ".")));
        }
        catch (Throwable x) {
            ExceptionUtils.throwException(x);
            return null;
        }
    }

    public static <P1, P2, R> SBiFunctionInfo parse(SBiFunction<P1, P2, R> lambda) {
        if (lambda == null) {
            return null;
        }
        SerializedLambda sl = LambdaUtils.getSerializedLambda(lambda);
        Matcher m = SBiFunctionPattern.matcher(sl.getInstantiatedMethodType());
        if (!m.find()) {
            throw new Error("can not resolve instantiatedMethodType: " + sl.getInstantiatedMethodType());
        }
        try {
            return new SBiFunctionInfo(Class.forName(m.group(1).replaceAll("/", ".")), Class.forName(m.group(2).replaceAll("/", ".")), Class.forName(m.group(3).replaceAll("/", ".")));
        }
        catch (Throwable x) {
            ExceptionUtils.throwException(x);
            return null;
        }
    }

    public static <P> SConsumerInfo parse(SConsumer<P> lambda) {
        if (lambda == null) {
            return null;
        }
        SerializedLambda sl = LambdaUtils.getSerializedLambda(lambda);
        Matcher m = SConsumerPattern.matcher(sl.getInstantiatedMethodType());
        if (!m.find()) {
            throw new Error("can not resolve instantiatedMethodType: " + sl.getInstantiatedMethodType());
        }
        try {
            return new SConsumerInfo(Class.forName(m.group(1).replaceAll("/", ".")));
        }
        catch (Throwable x) {
            ExceptionUtils.throwException(x);
            return null;
        }
    }

    public static <P1, P2> SBiConsumerInfo parse(SBiConsumer<P1, P2> lambda) {
        if (lambda == null) {
            return null;
        }
        SerializedLambda sl = LambdaUtils.getSerializedLambda(lambda);
        Matcher m = SBiConsumerPattern.matcher(sl.getInstantiatedMethodType());
        if (!m.find()) {
            throw new Error("can not resolve instantiatedMethodType: " + sl.getInstantiatedMethodType());
        }
        try {
            return new SBiConsumerInfo(Class.forName(m.group(1).replaceAll("/", ".")), Class.forName(m.group(2).replaceAll("/", ".")));
        }
        catch (Throwable x) {
            ExceptionUtils.throwException(x);
            return null;
        }
    }

    public static <R> SSupplierInfo parse(SSupplier<R> lambda) {
        if (lambda == null) {
            return null;
        }
        SerializedLambda sl = LambdaUtils.getSerializedLambda(lambda);
        Matcher m = SSupplierrPattern.matcher(sl.getInstantiatedMethodType());
        if (!m.find()) {
            throw new Error("can not resolve instantiatedMethodType: " + sl.getInstantiatedMethodType());
        }
        try {
            return new SSupplierInfo(Class.forName(m.group(1).replaceAll("/", ".")));
        }
        catch (Throwable x) {
            ExceptionUtils.throwException(x);
            return null;
        }
    }

    public static SerializedLambda getSerializedLambda(SSerializable lambda) {
        Method writeReplaceMethod;
        SerializedLambda serializedLambda = cache.get(lambda.getClass().getName());
        if (serializedLambda != null) {
            return serializedLambda;
        }
        try {
            writeReplaceMethod = lambda.getClass().getDeclaredMethod("writeReplace", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        boolean isAccessible = writeReplaceMethod.isAccessible();
        writeReplaceMethod.setAccessible(true);
        try {
            serializedLambda = (SerializedLambda)writeReplaceMethod.invoke((Object)lambda, new Object[0]);
            cache.put(lambda.getClass().getName(), serializedLambda);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Error(e);
        }
        writeReplaceMethod.setAccessible(isAccessible);
        return serializedLambda;
    }
}

