/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.time;

import com.github.azbh111.utils.java.datetime.DateTimeUtils;
import com.github.azbh111.utils.java.time.TimeParseException;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class TimeUtils {
    public static final Map<String, DateTimeFormatter> standardTimeFormatters = new LinkedHashMap<String, DateTimeFormatter>();
    public static final Clock SYSTEM_DEFAULT_ZONE_CLOCK = Clock.systemDefaultZone();
    public static final Clock UTC_CLOCK = Clock.systemUTC();
    public static final ZoneId SYSTEM_DEFAULT_ZONE_ID = SYSTEM_DEFAULT_ZONE_CLOCK.getZone();
    public static final ZoneId UTC_ZONE_ID = UTC_CLOCK.getZone();

    public static LocalTime from(TemporalAccessor temporal) {
        if (temporal instanceof LocalTime) {
            return (LocalTime)temporal;
        }
        if (temporal instanceof Instant) {
            return ((Instant)temporal).atZone(SYSTEM_DEFAULT_ZONE_ID).toLocalTime();
        }
        try {
            int second;
            int hour = temporal.isSupported(ChronoField.HOUR_OF_DAY) ? temporal.get(ChronoField.HOUR_OF_DAY) : 0;
            int minute = temporal.isSupported(ChronoField.MINUTE_OF_HOUR) ? temporal.get(ChronoField.MINUTE_OF_HOUR) : 0;
            int n = second = temporal.isSupported(ChronoField.SECOND_OF_MINUTE) ? temporal.get(ChronoField.SECOND_OF_MINUTE) : 0;
            int nano = temporal.isSupported(ChronoField.NANO_OF_SECOND) ? temporal.get(ChronoField.NANO_OF_SECOND) : (temporal.isSupported(ChronoField.MILLI_OF_SECOND) ? temporal.get(ChronoField.MILLI_OF_SECOND) * 1000000 : 0);
            return LocalTime.of(hour, minute, second, nano);
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain LocalDateTime from TemporalAccessor: " + temporal + " of type " + temporal.getClass().getName(), ex);
        }
    }

    public static LocalTime from(Date date) {
        return date.toInstant().atZone(SYSTEM_DEFAULT_ZONE_ID).toLocalTime();
    }

    public static LocalTime now() {
        return LocalTime.now();
    }

    public static LocalTime parse(String timeStr, String format) {
        DateTimeFormatter f = DateTimeUtils.getOrCreateDateTimeFormatter(format);
        return LocalTime.parse(timeStr, f);
    }

    public static LocalTime tryParse(String str) {
        TemporalAccessor t = null;
        for (DateTimeFormatter formatter : standardTimeFormatters.values()) {
            LocalTime dt;
            try {
                t = formatter.parse((CharSequence)str, Instant::from);
                dt = TimeUtils.from(t);
            }
            catch (Throwable e1) {
                try {
                    t = formatter.parse(str);
                    dt = TimeUtils.from(t);
                }
                catch (DateTimeParseException e2) {
                    continue;
                }
            }
            return dt;
        }
        throw new TimeParseException("Unable to parse " + str + " to LocalTime");
    }

    public static boolean isMorning() {
        return TimeUtils.isMorning(TimeUtils.now());
    }

    public static boolean isMorning(Date d) {
        return TimeUtils.isMorning(TimeUtils.from(d));
    }

    public static boolean isMorning(LocalTime t) {
        return t.get(ChronoField.AMPM_OF_DAY) == 0;
    }

    public static boolean isAfternoon() {
        return TimeUtils.isAfternoon(TimeUtils.now());
    }

    public static boolean isAfternoon(Date d) {
        return TimeUtils.isAfternoon(TimeUtils.from(d));
    }

    public static boolean isAfternoon(LocalTime t) {
        return t.get(ChronoField.AMPM_OF_DAY) == 1;
    }

    static {
        standardTimeFormatters.put("ISO_LOCAL_TIME", DateTimeFormatter.ISO_LOCAL_TIME);
        standardTimeFormatters.put("ISO_OFFSET_TIME", DateTimeFormatter.ISO_OFFSET_TIME);
        standardTimeFormatters.put("ISO_TIME", DateTimeFormatter.ISO_TIME);
    }
}

