/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.math.matrix.model;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;

public class BooleanMatrix2 {
    private int with;
    private int height;
    private BitSet[] matrix2;

    public BooleanMatrix2(int with, int height) {
        this.with = with;
        this.height = height;
        this.matrix2 = new BitSet[with];
        for (int i = 0; i < with; ++i) {
            this.matrix2[i] = new BitSet(height);
        }
    }

    public int getWith() {
        return this.with;
    }

    public void setWith(int with) {
        this.with = with;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isOn(int w, int h) {
        return this.get(w, h);
    }

    public boolean isOff(int w, int h) {
        return !this.get(w, h);
    }

    public boolean setOnIfOff(int w, int h) {
        if (this.isOff(w, h)) {
            this.setOn(w, h);
            return true;
        }
        return false;
    }

    public boolean setOffIfOn(int w, int h) {
        if (this.isOn(w, h)) {
            this.setOff(w, h);
            return true;
        }
        return false;
    }

    public BooleanMatrix2 setOn(int w, int h) {
        this.check(w, h);
        this.matrix2[w].set(h);
        return this;
    }

    public BooleanMatrix2 setOff(int w, int h) {
        this.check(w, h);
        this.matrix2[w].clear(h);
        return this;
    }

    public BooleanMatrix2 set(int w, int h, int status) {
        if (status != 0) {
            return this.setOn(w, h);
        }
        return this.setOff(w, h);
    }

    public boolean get(int w, int h) {
        this.check(w, h);
        return this.matrix2[w].get(h);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanMatrix2 matrix21 = (BooleanMatrix2)o;
        return this.with == matrix21.with && this.height == matrix21.height && Arrays.equals(this.matrix2, matrix21.matrix2);
    }

    public int hashCode() {
        int result = Objects.hash(this.with, this.height);
        result = 31 * result + Arrays.hashCode(this.matrix2);
        return result;
    }

    private void check(int w, int h) {
        if (w >= this.with) {
            throw new IndexOutOfBoundsException(this.with + "," + w);
        }
        if (h >= this.height) {
            throw new IndexOutOfBoundsException(this.height + "," + h);
        }
    }
}

