/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.stack;

import com.github.azbh111.utils.java.stack.model.StackTraceInfo;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class StackTraceManager {
    private final Set<String> packagePrefixs = new HashSet<String>();
    private final Set<String> packageExecludes = new HashSet<String>();
    private final Map<String, LoggerStackTraceElement> projectStackTraceCache = new ConcurrentHashMap<String, LoggerStackTraceElement>();
    private static final StackTraceManager instance = new StackTraceManager();

    public StackTraceManager() {
        this.packagePrefixs.add("org.quartz.");
        this.packageExecludes.add("java.");
        this.packageExecludes.add("javax.");
        this.packageExecludes.add("sun.");
        this.packageExecludes.add("com.alibaba.druid.");
    }

    public StackTraceInfo getStackTraceInfo() {
        StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
        int length = stackTraces.length;
        LoggerStackTraceElement preStackTrace = null;
        LoggerStackTraceElement currentStackTrace = null;
        StackTraceInfo info = new StackTraceInfo();
        for (int i = 0; i < length; ++i) {
            StackTraceElement stackTrace = stackTraces[i];
            preStackTrace = currentStackTrace;
            currentStackTrace = this.toLoggerStackTrace(stackTrace);
            if (currentStackTrace.isProxy() || !currentStackTrace.isProjectClass()) continue;
            if (preStackTrace != null) {
                info.setInvokeMethodName(stackTraces[i - 1].getMethodName());
            }
            info.setMethodName(stackTraces[i].getMethodName());
            info.setFileName(currentStackTrace.getFileName());
            info.setLineNumer(stackTrace.getLineNumber());
            return info;
        }
        return info;
    }

    private LoggerStackTraceElement toLoggerStackTrace(StackTraceElement element) {
        LoggerStackTraceElement loggerStackTraceElement = this.projectStackTraceCache.get(element.getClassName());
        if (loggerStackTraceElement == null) {
            loggerStackTraceElement = this.parse(element);
            this.projectStackTraceCache.put(element.getClassName(), loggerStackTraceElement);
        }
        return loggerStackTraceElement;
    }

    private boolean isProjectStackTrace(StackTraceElement element) {
        String className = element.getClassName();
        block0: for (String prefix : this.packagePrefixs) {
            if (!className.startsWith(prefix)) continue;
            for (String execlude : this.packageExecludes) {
                if (!className.startsWith(execlude)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private LoggerStackTraceElement parse(StackTraceElement element) {
        return LoggerStackTraceElement.builder().proxy(element.getClassName().contains("$$") || element.getClassName().startsWith("com.sun.proxy.$Proxy")).fileName(this.trimJavaSuffix(element.getFileName())).projectClass(this.isProjectStackTrace(element)).build();
    }

    private String trimJavaSuffix(String fileName) {
        if (fileName == null) {
            return "";
        }
        return fileName.endsWith(".java") ? fileName.substring(0, fileName.length() - 5) : fileName;
    }

    public Set<String> getPackagePrefixs() {
        return this.packagePrefixs;
    }

    public Set<String> getPackageExecludes() {
        return this.packageExecludes;
    }

    public static StackTraceManager getInstance() {
        return instance;
    }

    private static class LoggerStackTraceElement {
        private boolean proxy;
        private boolean projectClass;
        private String fileName;

        LoggerStackTraceElement(boolean proxy, boolean projectClass, String fileName) {
            this.proxy = proxy;
            this.projectClass = projectClass;
            this.fileName = fileName;
        }

        public static LoggerStackTraceElementBuilder builder() {
            return new LoggerStackTraceElementBuilder();
        }

        public boolean isProxy() {
            return this.proxy;
        }

        public boolean isProjectClass() {
            return this.projectClass;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String toString() {
            return "StackTraceManager.LoggerStackTraceElement(proxy=" + this.isProxy() + ", projectClass=" + this.isProjectClass() + ", fileName=" + this.getFileName() + ")";
        }

        public static class LoggerStackTraceElementBuilder {
            private boolean proxy;
            private boolean projectClass;
            private String fileName;

            LoggerStackTraceElementBuilder() {
            }

            public LoggerStackTraceElementBuilder proxy(boolean proxy) {
                this.proxy = proxy;
                return this;
            }

            public LoggerStackTraceElementBuilder projectClass(boolean projectClass) {
                this.projectClass = projectClass;
                return this;
            }

            public LoggerStackTraceElementBuilder fileName(String fileName) {
                this.fileName = fileName;
                return this;
            }

            public LoggerStackTraceElement build() {
                return new LoggerStackTraceElement(this.proxy, this.projectClass, this.fileName);
            }

            public String toString() {
                return "StackTraceManager.LoggerStackTraceElement.LoggerStackTraceElementBuilder(proxy=" + this.proxy + ", projectClass=" + this.projectClass + ", fileName=" + this.fileName + ")";
            }
        }
    }
}

