package com.github.azbh111.utils.java.exception;

import com.github.azbh111.utils.java.model.ResStatus;

/**
 * 业务异常, 直接返回给前端
 *
 * @author: zyp
 * @date: 2021/2/24 15:20
 */
public class BizException extends RuntimeException {
    private static final long serialVersionUID = -2691266615201630475L;
    private int code;
    private String msg;
    private Object data;

    public BizException(ResStatus status) {
        super(status.getDisplayMsg() != null ? status.getDisplayMsg() : status.getDesc());
        code = status.getStatus();
        msg = status.getDisplayMsg();
        if (msg == null) {
            msg = status.getDesc();
        }
    }

    public BizException(int code, String msg) {
        super(msg);
        this.code = code;
        this.msg = msg;
    }

    public BizException(int code, String msg, Object data) {
        super(msg);
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public BizException(ResStatus status, Throwable cause) {
        super(status.getDisplayMsg() != null ? status.getDisplayMsg() : status.getDesc(), cause);
        code = status.getStatus();
        msg = status.getDisplayMsg();
        if (msg == null) {
            msg = status.getDesc();
        }
    }

    public BizException(int code, String msg, Throwable cause) {
        super(msg, cause);
        this.code = code;
        this.msg = msg;
    }

    public BizException(int code, String msg, Object data, Throwable cause) {
        super(msg, cause);
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public Object getData() {
        return data;
    }
}
