package com.github.azbh111.utils.java.random;

import com.github.azbh111.utils.java.annotation.Nonnull;
import com.github.azbh111.utils.java.string.StringUtils;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

/**
 * @author: zyp
 * @date: 2020/10/9 11:23 上午
 */
public class RandomUtils {

    private static final SecureRandom random;
    private static final char[] numbers = "0123456789".toCharArray();
    private static final char[] letters_lower = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] letters_upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] common_chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    static {
        SecureRandom r;
//        try {
//        SecureRandom.getInstanceStrong()会使用/dev/random来产生高质量随机数, 是阻塞的. 如果linux服务器的熵池为空, 就会阻塞
//            r = SecureRandom.getInstanceStrong();
//        } catch (NoSuchAlgorithmException e) {
            Random rd = new Random();
            byte[] seed = new byte[1024];
            rd.nextBytes(seed);
            r = new SecureRandom(seed);
//        }
        random = r;
    }

    public static byte[] nextBytes(int length) {
        if (length == 0) {
            return new byte[0];
        }
        byte[] container = new byte[length];
        nextBytes(container);
        return container;
    }


    public static void nextBytes(byte[] bytes) {
        random.nextBytes(bytes);
    }

    public static int[] nextInts(int length) {
        if (length == 0) {
            return new int[0];
        }
        int[] container = new int[length];
        nextInts(container);
        return container;
    }

    public static void nextInts(int[] container) {
        int length = container.length;
        for (int i = 0; i < length; i++) {
            container[i] = nextInt();
        }
    }

    public static int nextInt() {
        return random.nextInt();
    }


    public static int nextInt(int bound) {
        return random.nextInt(bound);
    }


    public static long[] nextLongs(int length) {
        if (length == 0) {
            return new long[0];
        }
        long[] container = new long[length];
        nextLongs(container);
        return container;
    }

    public static void nextLongs(long[] container) {
        int length = container.length;
        for (int i = 0; i < length; i++) {
            container[i] = nextLong();
        }
    }

    public static long nextLong() {
        return random.nextLong();
    }

    public static float[] nextFloats(int length) {
        if (length == 0) {
            return new float[0];
        }
        float[] container = new float[length];
        nextFloats(container);
        return container;
    }

    public static void nextFloats(float[] container) {
        int length = container.length;
        for (int i = 0; i < length; i++) {
            container[i] = nextFloat();
        }
    }


    public static float nextFloat() {
        return random.nextFloat();
    }


    public static double[] nextDoubles(int length) {
        if (length == 0) {
            return new double[0];
        }
        double[] container = new double[length];
        nextDoubles(container);
        return container;
    }

    public static void nextDoubles(double[] container) {
        int length = container.length;
        for (int i = 0; i < length; i++) {
            container[i] = nextDouble();
        }
    }

    public static double nextDouble() {
        return random.nextDouble();
    }

    public static boolean[] nextBooleans(int length) {
        if (length == 0) {
            return new boolean[0];
        }
        boolean[] container = new boolean[length];
        nextBooleans(container);
        return container;
    }

    public static void nextBooleans(boolean[] container) {
        int length = container.length;
        for (int i = 0; i < length; i++) {
            container[i] = nextBoolean();
        }
    }

    public static boolean nextBoolean() {
        return random.nextBoolean();
    }

    public static double nextGaussian() {
        return random.nextGaussian();
    }


    /**
     * 用给定的候选字符生成随机字串
     * [start, end)
     *
     * @param count
     * @param candidates
     * @param start
     * @param end
     * @return
     */
    public static String nextString(int count, @Nonnull char[] candidates, int start, int end) {
        if (count <= 0) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end > candidates.length) {
            end = candidates.length;
        }
        if (end <= start) {
            return "";
        }
        char[] chars = new char[count];
        int candidateLength = end - start;
        for (int i = 0; i < count; i++) {
            chars[i] = candidates[random.nextInt(candidateLength) + start];
        }
        return StringUtils.newStringZeroCopy(chars);
    }

    /**
     * 用给定的候选字符生成随机字串
     *
     * @param count
     * @param candidates
     * @return
     */
    public static String nextString(int count, @Nonnull char[] candidates) {
        return nextString(count, candidates, 0, candidates.length);
    }

    /**
     * 生成随机字串
     *
     * @param count
     * @return
     */
    public static String nextString(int count) {
        return nextString(count, common_chars);
    }

    /**
     * 生成随机数字字符串
     *
     * @param count
     * @return
     */
    public static String nextNumberString(int count) {
        return nextString(count, numbers);
    }

    /**
     * 生成随机小写字母字符串
     *
     * @param count
     * @return
     */
    public static String nextLetterLowerString(int count) {
        return nextString(count, letters_lower);
    }

    /**
     * 生成随机大写字母字符串
     *
     * @param count
     * @return
     */
    public static String nextLetterUpperString(int count) {
        return nextString(count, letters_upper);
    }

    /**
     * 生成随机字母字符串
     *
     * @param count
     * @return
     */
    public static String nextLetterString(int count) {
        return nextString(count, letters);
    }

}
