package com.github.azbh111.utils.java.thread;

/**
 * @author pyz
 * @date 2019/10/14 9:58 上午
 */
public class ThreadUtils {
    /**
     * 休眠指定时间
     *
     * @param ms 毫秒
     */
    public static void sleep(long ms) throws InterruptedException {
        Thread.sleep(ms);
    }

    /**
     * 休眠指定时间
     * 如果休眠被打断,会直接返回,不会抛异常
     *
     * @param ms 毫秒
     */
    public static void sleepSafe(long ms) {
        try {
            Thread.sleep(ms);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}
