/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;

public class ExceptionUtils {
    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static Throwable unwrap(Throwable e) {
        Throwable unwrap;
        if (e == null) {
            return null;
        }
        Throwable pre = e;
        while ((unwrap = ExceptionUtils.unwarpOnce(pre)) != null) {
            pre = unwrap;
        }
        return pre;
    }

    public static <T> T unwrap(Throwable e, Class<T> upper) {
        if (e == null) {
            return null;
        }
        Throwable pre = e;
        while (!upper.isInstance(pre)) {
            Throwable unwrap = ExceptionUtils.unwarpOnce(pre);
            if (unwrap == null) {
                return null;
            }
            pre = unwrap;
        }
        return (T)pre;
    }

    public static void throwException(Throwable e) {
        ExceptionUtils.rethrow0(e);
    }

    private static Throwable unwarpOnce(Throwable e) {
        Throwable unwrap;
        if (e instanceof InvocationTargetException) {
            unwrap = ((InvocationTargetException)e).getTargetException();
        } else {
            if (e instanceof UndeclaredThrowableException) {
                return ((UndeclaredThrowableException)e).getUndeclaredThrowable();
            }
            unwrap = e.getClass().getSimpleName().contains("Nested") ? e.getCause() : null;
        }
        return unwrap;
    }

    private static <E extends Throwable> void rethrow0(Throwable e) throws E {
        throw e;
    }
}

