/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.reflect;

import com.github.azbh111.utils.java.reflect.model.MuttableGenericArrayType;
import com.github.azbh111.utils.java.reflect.model.MuttableParameterizedType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class GenericUtils {
    public static ParameterizedType getGenericSuperclass(Class from, Class to) {
        return GenericUtils.resolve(from, new LinkedList<GenericNode>(), 0, to);
    }

    public static ParameterizedType getGenericSuperclass(ParameterizedType from, Class to) {
        LinkedList<GenericNode> nodes = new LinkedList<GenericNode>();
        GenericNode node = new GenericNode();
        node.setSource(from);
        node.setBridges(((Class)from.getRawType()).getTypeParameters());
        nodes.add(node);
        return GenericUtils.resolve((Class)from.getRawType(), nodes, 0, to);
    }

    public static Type replaceTypeVariable(Type target, String name, Type type) {
        Type r = target;
        if (target instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)target;
            if (tv.getName().equals(name)) {
                r = type;
            }
        } else if (target instanceof ParameterizedType) {
            MuttableParameterizedType mpt = target instanceof MuttableParameterizedType ? (MuttableParameterizedType)target : MuttableParameterizedType.of((ParameterizedType)target);
            Type[] ts = mpt.getActualTypeArguments();
            for (int i = 0; i < ts.length; ++i) {
                ts[i] = GenericUtils.replaceTypeVariable(ts[i], name, type);
            }
            r = mpt;
        } else if (target instanceof GenericArrayType) {
            MuttableGenericArrayType mgat = target instanceof MuttableGenericArrayType ? (MuttableGenericArrayType)target : MuttableGenericArrayType.of((GenericArrayType)target);
            mgat.setGenericComponentType(GenericUtils.replaceTypeVariable(mgat.getGenericComponentType(), name, type));
            r = mgat;
        }
        return r;
    }

    private static ParameterizedType resolve(Class from, LinkedList<GenericNode> stacks, int skip, Class to) {
        if (from == to) {
            return GenericUtils.resolve(stacks, skip, to);
        }
        Class sc = from.getSuperclass();
        Type gsc = from.getGenericSuperclass();
        Class<?>[] itfs = from.getInterfaces();
        Type[] gitfs = from.getGenericInterfaces();
        int size = itfs.length;
        for (int i = -1; i < size; ++i) {
            Type genericSuperClass;
            Class superClass = i == -1 ? sc : itfs[i];
            Type type = genericSuperClass = i == -1 ? gsc : gitfs[i];
            if (superClass == null || genericSuperClass == null || !to.isAssignableFrom(superClass)) continue;
            TypeVariable[] tps = superClass.getTypeParameters();
            if (tps == null || tps.length == 0 || !(genericSuperClass instanceof ParameterizedType)) {
                ParameterizedType pt = GenericUtils.resolve(superClass, stacks, stacks.size(), to);
                if (pt == null) continue;
                return pt;
            }
            GenericNode node = new GenericNode();
            node.setSource((ParameterizedType)genericSuperClass);
            node.setBridges(tps);
            stacks.add(node);
            ParameterizedType pt = GenericUtils.resolve(superClass, stacks, 0, to);
            if (pt == null) continue;
            return pt;
        }
        return null;
    }

    private static ParameterizedType resolve(LinkedList<GenericNode> stacks, int skip, Class to) {
        MuttableParameterizedType target = new MuttableParameterizedType();
        target.setRawType(to);
        target.setActualTypeArguments(new Type[to.getTypeParameters().length]);
        System.arraycopy(to.getTypeParameters(), 0, target.getActualTypeArguments(), 0, target.getActualTypeArguments().length);
        GenericUtils.resolve(stacks, skip, target);
        return target;
    }

    private static void resolve(List<GenericNode> nodes, int skip, MuttableParameterizedType target) {
        ListIterator<GenericNode> it = nodes.listIterator(nodes.size() - skip);
        while (it.hasPrevious()) {
            GenericUtils.resolve(it.previous(), target);
        }
    }

    private static void resolve(GenericNode node, MuttableParameterizedType target) {
        TypeVariable[] bridges = node.getBridges();
        Type[] sources = node.getSource().getActualTypeArguments();
        for (int i = 0; i < node.getBridges().length; ++i) {
            GenericUtils.replaceTypeVariable(target, bridges[i].getName(), sources[i]);
        }
    }

    private static class GenericNode {
        ParameterizedType source;
        TypeVariable[] bridges;

        private GenericNode() {
        }

        public ParameterizedType getSource() {
            return this.source;
        }

        public void setSource(ParameterizedType source) {
            this.source = source;
        }

        public TypeVariable[] getBridges() {
            return this.bridges;
        }

        public void setBridges(TypeVariable[] bridges) {
            this.bridges = bridges;
        }

        public void setBridges(Type[] actualTypeArguments) {
        }
    }
}

