package com.github.azbh111.utils.java.code;

import com.github.azbh111.utils.java.charset.Charsets;
import com.github.azbh111.utils.java.io.IOUtils;
import com.github.azbh111.utils.java.io.stream.CounterInputStream;
import com.github.azbh111.utils.java.io.stream.CounterOutputStream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;

/**
 * @author: zyp
 * @date: 2020/1/19 1:51 PM
 */
public class Base64Utils {

    public static String encodeToString(byte[] bytes) {
        return encodeToString(bytes, false);
    }

    public static String encodeToString(byte[] bytes, boolean url) {
        return new String(encode(bytes, url), Charsets.UTF_8);
    }

    public static byte[] encode(byte[] bytes) {
        return encode(bytes, false);
    }

    public static byte[] encode(byte[] bytes, boolean url) {
        return getEncoder(url).encode(bytes);
    }

    public static byte[] decode(byte[] bytes) {
        return decode(bytes, false);
    }

    public static byte[] decode(byte[] bytes, boolean url) {
        return getDecoder(url).decode(bytes);
    }

    public static byte[] decode(String base64) {
        return decode(base64, false);
    }

    public static byte[] decode(String base64, boolean url) {
        return getDecoder(url).decode(base64);
    }

    public static Counter encodeLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        return encodeLarge(inputStream, outputStream, false);
    }

    public static Counter encodeLarge(InputStream inputStream, OutputStream outputStream, boolean url) throws IOException {
        CounterOutputStream counterOutputStream = new CounterOutputStream(outputStream);
        OutputStream base64OutputStream = wrap(counterOutputStream, url);
        long input = IOUtils.copy(inputStream, base64OutputStream);
        long output = counterOutputStream.getCount();
        return new Counter(input, output);
    }

    public static Counter decodeLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        return decodeLarge(inputStream, outputStream, false);
    }

    public static Counter decodeLarge(InputStream inputStream, OutputStream outputStream, boolean url) throws IOException {
        CounterInputStream counterInputStream = new CounterInputStream(inputStream);
        InputStream base64InputStream = wrap(counterInputStream, url);
        long input = counterInputStream.getCount();
        long output = IOUtils.copy(base64InputStream, outputStream);
        return new Counter(input, output);
    }

    public static InputStream wrap(InputStream inputStream) {
        return wrap(inputStream, false);
    }

    public static InputStream wrap(InputStream inputStream, boolean url) {
        return getDecoder(url).wrap(inputStream);
    }

    public static OutputStream wrap(OutputStream outputStream) {
        return wrap(outputStream, false);
    }

    public static OutputStream wrap(OutputStream outputStream, boolean url) {
        return getEncoder(url).wrap(outputStream);
    }

    public static Base64.Encoder getEncoder(boolean url) {
        return url ? Base64.getUrlEncoder() : Base64.getEncoder();
    }

    public static Base64.Decoder getDecoder(boolean url) {
        return url ? Base64.getUrlDecoder() : Base64.getDecoder();
    }

    public static class Counter {
        private final long input;
        private final long output;

        public Counter(long input, long output) {
            this.input = input;
            this.output = output;
        }

        public long getInput() {
            return input;
        }

        public long getOutput() {
            return output;
        }
    }
}
