package com.github.azbh111.utils.java.model;

import com.github.azbh111.utils.java.exception.UnexpectedException;
import com.github.azbh111.utils.java.reflect.ObjectUtils;

/**
 * 实现此接口的对象,可以调用deepCopy进行深拷贝
 *
 * @author pyz
 * @date 2019/12/19 9:59 上午
 */
public interface DeepCopy {
    default DeepCopy deepCopy() {
        try {
            return ObjectUtils.deepCopy(this);
        } catch (InstantiationException e) {
            throw new UnexpectedException(e);
        }
    }
}
