package com.github.azbh111.utils.java.uid;

/**
 * @author: zyp
 * @date: 2020/8/24 4:51 下午
 */
public interface UidGenerator {

    /**
     * Get a unique ID
     *
     * @return UID
     * @throws UidGenerateException
     */
    long getUID() throws UidGenerateException;

    /**
     * Parse the UID into elements which are used to generate the UID. <br>
     * Such as timestamp & workerId & sequence...
     *
     * @param uid
     * @return Parsed info
     */
    String parseUID(long uid);

    /**
     * 创建DefaultUidGenerator
     *
     * @return
     */
    static DefaultUidGenerator.DefaultUidGeneratorBuilder defaultUidGeneratorBuilder() {
        return new DefaultUidGenerator.DefaultUidGeneratorBuilder();
    }
}
