/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.csv;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;

class CsvColumnDefine {
    private String name;
    private int order;
    private Field field;
    private Method method;
    private Function<Object, String> conventor;
    private String nullValue;

    public Object get(Object item) throws InvocationTargetException, IllegalAccessException {
        if (this.method != null) {
            return this.method.invoke(item, new Object[0]);
        }
        return this.field.get(item);
    }

    public static CsvColumnDefineBuilder builder() {
        return new CsvColumnDefineBuilder();
    }

    public CsvColumnDefineBuilder toBuilder() {
        return new CsvColumnDefineBuilder().name(this.name).order(this.order).field(this.field).method(this.method).conventor(this.conventor).nullValue(this.nullValue);
    }

    public String getName() {
        return this.name;
    }

    public int getOrder() {
        return this.order;
    }

    public Field getField() {
        return this.field;
    }

    public Method getMethod() {
        return this.method;
    }

    public Function<Object, String> getConventor() {
        return this.conventor;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public CsvColumnDefine() {
    }

    public CsvColumnDefine(String name, int order, Field field, Method method, Function<Object, String> conventor, String nullValue) {
        this.name = name;
        this.order = order;
        this.field = field;
        this.method = method;
        this.conventor = conventor;
        this.nullValue = nullValue;
    }

    public String toString() {
        return "CsvColumnDefine(super=" + super.toString() + ", name=" + this.getName() + ", order=" + this.getOrder() + ", field=" + this.getField() + ", method=" + this.getMethod() + ", conventor=" + this.getConventor() + ", nullValue=" + this.getNullValue() + ")";
    }

    public static class CsvColumnDefineBuilder {
        private String name;
        private int order;
        private Field field;
        private Method method;
        private Function<Object, String> conventor;
        private String nullValue;

        CsvColumnDefineBuilder() {
        }

        public CsvColumnDefineBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CsvColumnDefineBuilder order(int order) {
            this.order = order;
            return this;
        }

        public CsvColumnDefineBuilder field(Field field) {
            this.field = field;
            return this;
        }

        public CsvColumnDefineBuilder method(Method method) {
            this.method = method;
            return this;
        }

        public CsvColumnDefineBuilder conventor(Function<Object, String> conventor) {
            this.conventor = conventor;
            return this;
        }

        public CsvColumnDefineBuilder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public CsvColumnDefine build() {
            return new CsvColumnDefine(this.name, this.order, this.field, this.method, this.conventor, this.nullValue);
        }

        public String toString() {
            return "CsvColumnDefine.CsvColumnDefineBuilder(name=" + this.name + ", order=" + this.order + ", field=" + this.field + ", method=" + this.method + ", conventor=" + this.conventor + ", nullValue=" + this.nullValue + ")";
        }
    }
}

