/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Stopwatch {
    private final String name;
    private long start;
    private final List<String> steps = new ArrayList<String>();
    private final Map<String, long[]> timeMap = new HashMap<String, long[]>();
    private static final StopLogger soutStopLogger = (name, step, now, cost) -> System.out.println(String.format("stopwatch: %s stop at %s. cost %s ms.", step, now, cost));
    private static final StopLogger noopStopLogger = (name, step, now, cost) -> {};
    private static final StartLogger soutStartLogger = (name, step, now) -> System.out.println(String.format("stopwatch: %s start at %s.", step, now));
    private static final StartLogger noopStartLogger = (name, step, now) -> {};

    private Stopwatch(String name) {
        this.name = name;
        this.start = System.currentTimeMillis();
    }

    public static Stopwatch create(String name) {
        return new Stopwatch(name);
    }

    public static Stopwatch create() {
        return new Stopwatch("stopwatch");
    }

    public Stopwatch start(String ... steps) {
        return this.startAndLog(noopStartLogger, steps);
    }

    public Stopwatch startAndLog(String ... steps) {
        return this.startAndLog(soutStartLogger, steps);
    }

    public Stopwatch startAndLog(StartLogger logger, String ... steps) {
        if (steps == null || steps.length == 0) {
            return this;
        }
        long now = System.currentTimeMillis();
        for (String step : steps) {
            this.steps.add(step);
            this.timeMap.put(step, new long[]{now, 0L});
            logger.log(this.name, step, now);
        }
        return this;
    }

    public Stopwatch stop(String ... steps) {
        return this.stopAndLog(noopStopLogger, steps);
    }

    public Stopwatch stopAndLog(String ... steps) {
        return this.stopAndLog(soutStopLogger, steps);
    }

    public Stopwatch stopAndLog(StopLogger logger, String ... steps) {
        if (steps == null || steps.length == 0) {
            return this;
        }
        long now = System.currentTimeMillis();
        for (String step : steps) {
            long[] pair = this.timeMap.computeIfAbsent(step, k -> new long[]{this.start, 0L});
            pair[1] = now;
            logger.log(this.name, step, now, now - pair[0]);
        }
        return this;
    }

    public void reset() {
        this.start = System.currentTimeMillis();
        this.steps.clear();
        this.timeMap.clear();
    }

    public long getTime() {
        return System.currentTimeMillis() - this.start;
    }

    public String toString() {
        return "Stopwatch(name=" + this.getName() + ", start=" + this.start + ", steps=" + this.steps + ", timeMap=" + this.timeMap + ")";
    }

    public String getName() {
        return this.name;
    }

    public static interface StopLogger {
        public void log(String var1, String var2, long var3, long var5);
    }

    public static interface StartLogger {
        public void log(String var1, String var2, long var3);
    }
}

