/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javasocksproxyserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.bbottema.javasocksproxyserver.ProxyHandler;
import org.bbottema.javasocksproxyserver.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocksServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocksServer.class);
    protected int port;
    protected boolean stopping = false;

    public int getPort() {
        return this.port;
    }

    public synchronized void start(int listenPort) {
        this.stopping = false;
        this.port = listenPort;
        new Thread(new ServerProcess()).start();
    }

    public synchronized void stop() {
        this.stopping = true;
    }

    private class ServerProcess
    implements Runnable {
        private ServerProcess() {
            if (SocksServer.this == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/SocksServer$ServerProcess.<init> must not be null");
            }
        }

        @Override
        public void run() {
            LOGGER.debug("SOCKS server started...");
            try {
                this.handleClients(SocksServer.this.port);
                LOGGER.debug("SOCKS server stopped...");
            }
            catch (IOException e) {
                LOGGER.debug("SOCKS server crashed...");
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleClients(int port) throws IOException {
            ServerSocket listenSocket = new ServerSocket(port);
            listenSocket.setSoTimeout(200);
            SocksServer.this.port = listenSocket.getLocalPort();
            LOGGER.debug("SOCKS server listening at port: " + listenSocket.getLocalPort());
            while (true) {
                SocksServer socksServer = SocksServer.this;
                synchronized (socksServer) {
                    if (SocksServer.this.stopping) {
                        break;
                    }
                }
                this.handleNextClient(listenSocket);
            }
            try {
                listenSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void handleNextClient(ServerSocket listenSocket) {
            if (listenSocket == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/SocksServer$ServerProcess.handleNextClient must not be null");
            }
            try {
                Socket clientSocket = listenSocket.accept();
                clientSocket.setSoTimeout(200);
                LOGGER.debug("Connection from : " + Utils.getSocketInfo(clientSocket));
                new Thread(new ProxyHandler(clientSocket)).start();
            }
            catch (InterruptedIOException clientSocket) {
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

